/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.generator.base.GeneratorException;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.base.validation.IGeneratorResourceValidator;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ModelValidator
implements IGeneratorResourceValidator {
    private IResourceValidator resourceValidator;

    @Inject
    public ModelValidator(IResourceValidator validator) {
        this.resourceValidator = validator;
    }

    public void validate(List<Resource> resources, Arguments arguments, ILogger logger) {
        this.validateTransitiveClosure(resources, arguments, logger);
    }

    private void validateTransitiveClosure(List<Resource> resources, Arguments arguments, ILogger logger) {
        List list;
        logger.logInfo("-- validating models");
        int errors = 0;
        int warnings = 0;
        List<Resource> importedResources = this.computeImportedResources(resources);
        for (Resource resource : importedResources) {
            list = this.resourceValidator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            for (Issue issue : list) {
                if (issue.getSeverity() != Severity.ERROR) continue;
                ++errors;
                logger.logError(issue.toString());
            }
        }
        for (Resource resource : resources) {
            list = this.resourceValidator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            for (Issue issue : list) {
                if (issue.getSeverity() == Severity.ERROR) {
                    ++errors;
                    logger.logError(issue.toString());
                    continue;
                }
                if (issue.getSeverity() == Severity.WARNING) {
                    ++warnings;
                    logger.logWarning(issue.toString());
                    continue;
                }
                logger.logInfo(issue.toString());
            }
        }
        if (warnings > 0) {
            logger.logWarning(String.valueOf(warnings) + " warnings");
        }
        if (errors > 0) {
            logger.logError(String.valueOf(errors) + " errors");
            logger.logInfo("validation failed");
            logger.logInfo("-- terminating");
            throw new GeneratorException("validation failed");
        }
    }

    private List<Resource> computeImportedResources(List<Resource> resources) {
        LinkedHashSet closure = new LinkedHashSet();
        resources.forEach(r -> this.computeTransitiveClosure((Resource)r, closure));
        closure.removeAll(resources);
        return new ArrayList<Resource>(closure);
    }

    private void computeTransitiveClosure(Resource resource, Set<Resource> closure) {
        if (closure.add(resource)) {
            EcoreUtil.ExternalCrossReferencer.find((Resource)resource).keySet().stream().map(EObject::eResource).filter(Objects::nonNull).forEach(r -> this.computeTransitiveClosure((Resource)r, closure));
        }
    }
}

