/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.AstVisitor;
import org.eclipse.gmf.internal.xpand.ast.ErrorStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpandStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpressionStatement;
import org.eclipse.gmf.internal.xpand.ast.FileStatement;
import org.eclipse.gmf.internal.xpand.ast.ForEachStatement;
import org.eclipse.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.gmf.internal.xpand.ast.LetStatement;
import org.eclipse.gmf.internal.xpand.ast.ProtectStatement;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.ocl.ExpressionHelper;

public abstract class AbstractAstVisitor
implements AstVisitor {
    @Override
    public boolean visit(Template template) {
        return true;
    }

    @Override
    public boolean visit(XpandAdvice advice) {
        if (advice instanceof AbstractDefinition) {
            return this.visit((AbstractDefinition)((Object)advice));
        }
        return true;
    }

    @Override
    public boolean visit(XpandDefinition definition) {
        if (definition instanceof AbstractDefinition) {
            return this.visit((AbstractDefinition)((Object)definition));
        }
        return true;
    }

    protected boolean visit(AbstractDefinition definition) {
        return true;
    }

    @Override
    public boolean visit(ErrorStatement statement) {
        this.visitExpressionHelper(statement.getMessage());
        return true;
    }

    @Override
    public boolean visit(ExpandStatement statement) {
        ExpressionHelper[] expressionHelperArray = statement.getParameters();
        int n = expressionHelperArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionHelper parameter = expressionHelperArray[n2];
            this.visitExpressionHelper(parameter);
            ++n2;
        }
        if (statement.getSeparator() != null) {
            this.visitExpressionHelper(statement.getSeparator());
        }
        if (statement.getTarget() != null) {
            this.visitExpressionHelper(statement.getTarget());
        }
        return true;
    }

    @Override
    public boolean visit(ExpressionStatement statement) {
        this.visitExpressionHelper(statement.getExpression());
        return true;
    }

    @Override
    public boolean visit(FileStatement statement) {
        this.visitExpressionHelper(statement.getTargetFileName());
        return true;
    }

    @Override
    public boolean visit(ForEachStatement statement) {
        if (statement.getSeparator() != null) {
            this.visitExpressionHelper(statement.getSeparator());
        }
        this.visitExpressionHelper(statement.getTarget());
        return true;
    }

    @Override
    public boolean visit(IfStatement statement) {
        if (statement.getCondition() != null) {
            this.visitExpressionHelper(statement.getCondition());
        }
        return true;
    }

    @Override
    public boolean visit(LetStatement statement) {
        this.visitExpressionHelper(statement.getVarValue());
        return true;
    }

    @Override
    public boolean visit(ProtectStatement statement) {
        this.visitExpressionHelper(statement.getCommentStart());
        this.visitExpressionHelper(statement.getCommentEnd());
        this.visitExpressionHelper(statement.getId());
        return true;
    }

    @Override
    public boolean visit(TextStatement statement) {
        return true;
    }

    @Override
    public boolean visit(Statement statement) {
        return true;
    }

    protected void visitExpressionHelper(ExpressionHelper expressionHelper) {
    }
}

