/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.compartment;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.Identity;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.tooling.simplemap.model.triggers.AbstractTrigger;

class SetCompartmentNameTrigger
extends AbstractTrigger {
    private Compartment compartment;
    private String newName;

    public SetCompartmentNameTrigger(TransactionalEditingDomain domain, Compartment compartment, String newName) {
        super(domain);
        this.compartment = compartment;
        this.newName = newName;
    }

    @Override
    public void executeTrigger() {
        this.updateCanvas();
    }

    private void updateCanvas() {
        Label compartmentLabelToRename = this.getCompartmentLabel(this.compartment);
        ChildAccess accessorToRename = this.compartment.getAccessor();
        String newCompartmentName = this.getNewCanvasElementName(this.newName, (Identity)this.compartment);
        String newRectangleFigureName = String.valueOf(newCompartmentName) + "CompartmentFigure";
        String newAccessorName = "getFigure" + newRectangleFigureName;
        String newLabelFigureName = String.valueOf(newCompartmentName) + "CompartmentNameFigure";
        if (accessorToRename != null) {
            accessorToRename.setAccessor(newAccessorName);
            Figure compartmentFigureToRename = accessorToRename.getFigure();
            if (compartmentFigureToRename instanceof RealFigure) {
                ((RealFigure)compartmentFigureToRename).setName(newRectangleFigureName);
            }
        }
        if (compartmentLabelToRename != null) {
            compartmentLabelToRename.setName(newLabelFigureName);
            compartmentLabelToRename.setText(this.newName);
        }
    }

    private Label getCompartmentLabel(Compartment compartment) {
        Figure compartmentFigure;
        if (compartment.getAccessor() != null && (compartmentFigure = compartment.getAccessor().getFigure()) instanceof RealFigure) {
            for (Figure child : ((RealFigure)compartmentFigure).getChildren()) {
                if (!(child instanceof Label)) continue;
                return (Label)child;
            }
        }
        return null;
    }
}

