/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.epsilon.ecore.delegates.DelegateContext;
import org.eclipse.epsilon.ecore.delegates.notify.DelegateEPackageAdapter;

public abstract class DelegateUri {
    protected final String uri;

    public DelegateUri(String uri) {
        this.uri = uri;
    }

    public boolean isUsedBy(EModelElement target) {
        return target.getEAnnotation(this.uri) != null;
    }

    public DelegateContext context(DelegateEPackageAdapter adapter) {
        return adapter.delegateContext(this.uri);
    }

    public DelegateContext.ContextFactory factory(DelegateContext.ContextFactory.Registry registry) {
        return registry.getFactory(this.uri);
    }

    public void addContext(DelegateEPackageAdapter adapter, Supplier<DelegateContext> factory) {
        adapter.addDelegate(this.uri, uri -> (DelegateContext)factory.get());
    }

    public boolean is(String delegateURI) {
        return Objects.equals(this.uri, delegateURI);
    }

    public String toString() {
        return this.uri;
    }
}

