/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.html;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.epsilon.common.util.FileUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.html.HtmlPropertyGetter;
import org.eclipse.epsilon.emc.html.HtmlPropertySetter;
import org.eclipse.epsilon.emc.plainxml.PlainXmlType;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class HtmlModel
extends CachedModel<Element> {
    protected HttpStatusException httpException;
    protected Document document;
    protected final String ELEMENT_TYPE = "Element";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_URI = "uri";
    public static final String PROPERTY_TIMEOUT = "timeout";
    protected String uri = null;
    protected File file = null;
    protected int timeout = 60000;

    public HtmlModel() {
        this.propertyGetter = new HtmlPropertyGetter();
        this.propertySetter = new HtmlPropertySetter();
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        String fileProperty = properties.getProperty(PROPERTY_FILE);
        if (fileProperty != null && fileProperty.length() > 0) {
            this.file = new File(resolver.resolve(fileProperty));
        } else {
            this.uri = properties.getProperty(PROPERTY_URI);
            if (this.uri.startsWith("file:")) {
                try {
                    this.file = new File(new URI(this.uri));
                }
                catch (URISyntaxException e) {
                    throw new EolModelLoadingException((Exception)e, (IModel)this);
                }
            }
        }
        this.load();
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean isLoaded() {
        return this.file != null;
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        return null;
    }

    public String getTypeNameOf(Object instance) {
        return "t_" + ((Element)instance).tagName();
    }

    public Object getElementById(String id) {
        return null;
    }

    public String getElementId(Object instance) {
        return null;
    }

    public void setElementId(Object instance, String newId) {
    }

    public boolean owns(Object instance) {
        if (instance instanceof Element) {
            return ((Element)instance).ownerDocument() == this.document;
        }
        return false;
    }

    public boolean isInstantiable(String type) {
        return true;
    }

    public boolean hasType(String type) {
        return "Element".equals(type) || PlainXmlType.parse((String)type) != null;
    }

    public boolean store(String location) {
        try {
            FileUtil.setFileContents((String)this.document.html(), (File)new File(location));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean store() {
        if (this.file != null) {
            this.store(this.file.getAbsolutePath());
            return true;
        }
        throw new UnsupportedOperationException("Cannot save to " + this.uri);
    }

    protected Collection<Element> allContentsFromModel() {
        return this.document.getAllElements();
    }

    protected Collection<Element> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        return this.document.select(PlainXmlType.parse((String)type).getTagName());
    }

    protected Collection<Element> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        return this.getAllOfTypeFromModel(kind);
    }

    protected Element createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        return this.document.createElement(PlainXmlType.parse((String)type).getTagName());
    }

    protected void loadModel() throws EolModelLoadingException {
        if (this.readOnLoad) {
            try {
                if (this.file != null) {
                    this.document = Jsoup.parse((File)this.file, null);
                }
                Connection connection = Jsoup.connect((String)this.uri);
                connection.timeout(this.timeout);
                this.document = connection.get();
            }
            catch (HttpStatusException ex) {
                this.document = Document.createShell((String)this.uri);
                this.httpException = ex;
            }
            catch (IOException e) {
                throw new EolModelLoadingException((Exception)e, (IModel)this);
            }
        } else {
            String baseUri = null;
            baseUri = this.file != null ? this.file.toURI().toString() : (this.uri != null ? this.uri : "");
            this.document = Document.createShell((String)baseUri);
        }
    }

    protected void disposeModel() {
        this.httpException = null;
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        ((Element)instance).remove();
        return false;
    }

    protected Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return type;
    }

    protected Collection<String> getAllTypeNamesOf(Object instance) {
        return Collections.singleton(this.getTypeNameOf(instance));
    }

    public Document getDocument() {
        return this.document;
    }

    public HttpStatusException getHttpException() {
        return this.httpException;
    }
}

