/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.introspection;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.Reference;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.introspection.Categories;
import com.google.gdata.data.introspection.ICollection;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.Version;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection
extends ExtensionPoint
implements Reference,
ICollection {
    private Version coreVersion = Service.getVersion();
    private XmlNamespace atomPubNs = Namespaces.getAtomPubNs();
    private TextConstruct title;
    private String href;
    private List<String> accepts = new ArrayList<String>();
    private List<Categories> categoriesList = new ArrayList<Categories>();

    public Collection() {
    }

    public Collection(String href) {
        this(href, null);
    }

    public Collection(String href, TextConstruct title) {
        this.href = href;
        this.title = title;
    }

    public Collection(String href, TextConstruct title, String ... accepts) {
        this(href, title);
        this.accepts = Arrays.asList(accepts);
    }

    public static String getAtomEntryAcceptType() {
        if (Service.getVersion().isCompatible(Service.Versions.V1)) {
            return "entry";
        }
        return "application/atom+xml;type=entry";
    }

    @Override
    public TextConstruct getTitle() {
        return this.title;
    }

    public void setTitle(TextConstruct title) {
        this.title = title;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    public String getType() {
        return ContentType.getAtomFeed().toString();
    }

    @Override
    public List<String> getAcceptList() {
        return this.accepts;
    }

    public void addAccept(String accept) {
        this.accepts.add(accept);
    }

    public List<Categories> getCategoriesList() {
        return this.categoriesList;
    }

    public void addCategories(Categories c) {
        this.categoriesList.add(c);
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(1);
        if (this.coreVersion.isCompatible(Service.Versions.V1)) {
            attrs.add(new XmlWriter.Attribute("title", this.title.getPlainText()));
        }
        attrs.add(new XmlWriter.Attribute("href", this.href));
        w.startElement(this.atomPubNs, "collection", attrs, null);
        if (this.coreVersion.isCompatible(Service.Versions.V1)) {
            if (this.accepts != null) {
                StringBuffer acceptBuf = new StringBuffer();
                for (String accept : this.accepts) {
                    if (acceptBuf.length() != 0) {
                        acceptBuf.append(',');
                    }
                    acceptBuf.append(accept);
                }
                w.simpleElement(this.atomPubNs, "accept", null, acceptBuf.toString());
            }
        } else {
            if (this.title != null) {
                this.title.generateAtom(w, "title");
            }
            for (String accept : this.accepts) {
                if (this.accepts == null) continue;
                w.simpleElement(this.atomPubNs, "accept", null, accept);
            }
            for (Categories categories : this.getCategoriesList()) {
                categories.generate(w, extProfile);
            }
        }
        this.generateExtensions(w, extProfile);
        w.endElement(this.atomPubNs, "collection");
    }

    @Override
    public void consumeAttributes(AttributeHelper attrHelper) throws ParseException {
        this.href = attrHelper.consume("href", true);
        if (this.coreVersion.isCompatible(Service.Versions.V1)) {
            String titleAttr = attrHelper.consume("title", true);
            this.title = new PlainTextConstruct(titleAttr);
        }
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) {
        return new Handler(p, attrs);
    }

    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile, Attributes attrs) {
            super(Collection.this, extProfile, Collection.class, attrs);
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://www.w3.org/2005/Atom")) {
                if (localName.equals("title") && !Collection.this.coreVersion.isCompatible(Service.Versions.V1)) {
                    TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                    if (Collection.this.title != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateTitle);
                    }
                    Collection.this.title = chi.textConstruct;
                    return chi.handler;
                }
            } else if (namespace.equals(Collection.this.atomPubNs.getUri())) {
                if (localName.equals("accept")) {
                    return new AcceptHandler();
                }
                if (localName.equals("categories")) {
                    Categories newCategories = new Categories();
                    Collection.this.addCategories(newCategories);
                    Categories categories = newCategories;
                    categories.getClass();
                    return categories.new Categories.Handler(this.extProfile, attrs);
                }
            }
            return super.getChildHandler(namespace, localName, attrs);
        }

        public void processEndElement() throws ParseException {
            super.processEndElement();
            if (Collection.this.title == null) {
                throw new ParseException(CoreErrorDomain.ERR.collectionTitleRequired);
            }
        }

        class AcceptHandler
        extends XmlParser.ElementHandler {
            AcceptHandler() {
            }

            public void processEndElement() {
                if (this.value == null) {
                    this.value = "";
                }
                if (Collection.this.coreVersion.isCompatible(Service.Versions.V1)) {
                    Collection.this.accepts = Arrays.asList(this.value.split(","));
                } else {
                    Collection.this.addAccept(this.value);
                }
            }
        }
    }
}

