/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.factories;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.common.BaseEnhNodeFactoryImpl;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.common.EnhNodeFinder;
import org.apache.jena.ontapi.common.EnhNodeProducer;
import org.apache.jena.ontapi.common.OntConfig;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.common.WrappedEnhNodeFactory;
import org.apache.jena.ontapi.impl.factories.STDObjectFactories;
import org.apache.jena.ontapi.impl.objects.OntClassImpl;
import org.apache.jena.ontapi.impl.objects.OntSimpleClassImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.ontapi.utils.StdModels;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

final class OntClasses {
    public static final EnhNodeFinder CLASS_FINDER = new EnhNodeFinder.ByType(OWL2.Class);
    public static final EnhNodeFinder RESTRICTION_FINDER = new EnhNodeFinder.ByType(OWL2.Restriction);
    private static final Set<Node> COMPATIBLE_TYPES = Stream.of(OWL2.Class, RDFS.Class, RDFS.Datatype).map(FrontsNode::asNode).collect(Collectors.toUnmodifiableSet());

    OntClasses() {
    }

    public static boolean canBeNamedClass(Node n, EnhGraph eg, boolean useLegacyCheck) {
        if (!n.isURI()) {
            return false;
        }
        if (OntEnhGraph.asPersonalityModel(eg).getOntPersonality().getBuiltins().getNamedClasses().contains(n)) {
            return true;
        }
        Graph g = eg.asGraph();
        Set<Node> punnings = OntEnhGraph.asPersonalityModel(eg).getOntPersonality().getPunnings().getNamedClasses();
        if (!useLegacyCheck) {
            return g.contains(n, RDF.type.asNode(), OWL2.Class.asNode()) && !Graphs.hasOneOfType(n, g, punnings);
        }
        if (Graphs.hasOneOfType(n, g, punnings)) {
            return false;
        }
        return OntClasses.canBeClass(n, g);
    }

    public static boolean canBeClass(Node n, Graph g) {
        if (Graphs.hasOneOfType(n, g, COMPATIBLE_TYPES)) {
            return true;
        }
        return g.contains(Node.ANY, RDFS.domain.asNode(), n) || g.contains(Node.ANY, RDFS.range.asNode(), n);
    }

    public static EnhNodeFactory createClassExpressionFactory(OntConfig config, Type ... filters) {
        return OntClasses.createClassExpressionFactory(config, false, filters);
    }

    public static EnhNodeFactory createClassExpressionFactory(OntConfig config, boolean anyClass, Type ... filters) {
        return OntClasses.createClassExpressionFactory(config, anyClass, Arrays.asList(filters), List.of());
    }

    public static EnhNodeFactory createClassExpressionFactory(OntConfig config, boolean anyClass, List<Type> filters, List<Type> strict) {
        return OntClasses.createClassExpressionFactory(config, anyClass ? OntSimpleClassImpl.NamedImpl::new : null, filters, strict);
    }

    public static EnhNodeFactory createClassExpressionFactory(OntConfig config, BiFunction<Node, EnhGraph, EnhNode> namedClassProducer, List<Type> filters, List<Type> strict) {
        boolean useLegacyClassTest = config.getBoolean(OntModelControls.USE_LEGACY_COMPATIBLE_NAMED_CLASS_FACTORY);
        BiPredicate<Node, EnhGraph> namedClassFilter = namedClassProducer != null ? (node, graph) -> OntClasses.canBeNamedClass(node, graph, useLegacyClassTest) : null;
        BiPredicate<Node, EnhGraph> genericClassFilter = namedClassProducer != null && config.getBoolean(OntModelControls.ALLOW_GENERIC_CLASS_EXPRESSIONS) ? (node, graph) -> OntClasses.canBeClass(node, graph.asGraph()) : null;
        return new Factory(namedClassFilter, genericClassFilter, namedClassProducer, config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS), config.getBoolean(OntModelControls.USE_OWL2_QUALIFIED_CARDINALITY_RESTRICTION_FEATURE), filters, strict);
    }

    public static EnhNodeFactory createBooleanConnectivesAndIndividualEnumerationFactory(Class<? extends OntClassImpl> impl, Property predicate, Class<? extends RDFNode> view, BiFunction<Node, EnhGraph, EnhNode> producer, OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(impl, OWL2.Class, producer);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Class)).and((n, g) -> {
            try (ExtendedIterator<Triple> res = g.asGraph().find(n, predicate.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    if (!OntEnhGraph.canAs(view, ((Triple)res.next()).getObject(), g)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return OntEnhNodeFactories.createCommon(maker, CLASS_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createCardinalityRestrictionFactory(Class<? extends OntClassImpl.CardinalityRestrictionImpl<?, ?, ?>> impl, RestrictionType restrictionType, ObjectRestrictionType objectType, OntClassImpl.CardinalityType cardinalityType, BiFunction<Node, EnhGraph, EnhNode> producer, OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(impl, OWL2.Restriction, producer);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Restriction)).and(OntClasses.getCardinalityFilter(cardinalityType, objectType.view(), config.getBoolean(OntModelControls.USE_OWL2_QUALIFIED_CARDINALITY_RESTRICTION_FEATURE))).and(restrictionType.getFilter());
        return OntEnhNodeFactories.createCommon(maker, RESTRICTION_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createComponentRestrictionFactory(Class<? extends OntClassImpl.ComponentRestrictionImpl<?, ?, ?>> impl, RestrictionType propertyType, ObjectRestrictionType objectType, Property predicate, BiFunction<Node, EnhGraph, EnhNode> producer, OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(impl, OWL2.Restriction, producer);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Restriction)).and(propertyType.getFilter()).and(objectType.getFilter(predicate));
        return OntEnhNodeFactories.createCommon(maker, RESTRICTION_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createNaryRestrictionFactory(Class<? extends OntClassImpl.NaryRestrictionImpl<?, ?, ?>> impl, Property predicate) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(impl, OWL2.Restriction);
        EnhNodeFilter filter = EnhNodeFilter.ANON.and(new EnhNodeFilter.HasType(OWL2.Restriction)).and(new EnhNodeFilter.HasPredicate(OWL2.onProperties)).and(new EnhNodeFilter.HasPredicate(predicate));
        return OntEnhNodeFactories.createCommon(maker, RESTRICTION_FINDER, filter, new EnhNodeFilter[0]);
    }

    private static EnhNodeFilter getCardinalityFilter(OntClassImpl.CardinalityType type, Class<? extends RDFNode> objectType, boolean qualifiedCardinalityAllowed) {
        return (n, g) -> type.isNonQualified(n, g) || qualifiedCardinalityAllowed && type.isQualified(n, g, objectType);
    }

    public static EnhNodeFactory createOWL2ELObjectOneOfFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.OneOfImpl.class, OWL2.Class, OntClassImpl.OneOfImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Class)).and((n, g) -> {
            RDFList list = Iterators.findFirst(g.asGraph().find(n, OWL2.oneOf.asNode(), Node.ANY).filterKeep(it -> STDObjectFactories.RDF_LIST.canWrap(it.getObject(), g)).mapWith(it -> new RDFListImpl(it.getObject(), g))).orElse(null);
            if (list == null) {
                return false;
            }
            return Iterators.hasExactly(list.iterator(), 1);
        });
        return OntEnhNodeFactories.createCommon(maker, CLASS_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2QLObjectSomeValuesFromFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.QLObjectSomeValuesFromImpl.class, OWL2.Restriction, OntClassImpl.QLObjectSomeValuesFromImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Restriction)).and(RestrictionType.OBJECT.getFilter()).and(ObjectRestrictionType.NAMED_CLASS.getFilter(OWL2.someValuesFrom));
        return OntEnhNodeFactories.createCommon(maker, RESTRICTION_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2RLObjectSomeValuesFromFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.RLObjectSomeValuesFromImpl.class, OWL2.Restriction, OntClassImpl.RLObjectSomeValuesFromImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Restriction)).and(RestrictionType.OBJECT.getFilter()).and((n, g) -> {
            try (ExtendedIterator<Triple> res = g.asGraph().find(n, OWL2.someValuesFrom.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    Node node = ((Triple)res.next()).getObject();
                    OntClass clazz = OntEnhGraph.asPersonalityModel(g).safeFindNodeAs(node, OntClass.class);
                    if (clazz == null) continue;
                    if (!OWL2.Thing.equals(clazz) && !clazz.canAsSubClass()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return OntEnhNodeFactories.createCommon(maker, RESTRICTION_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2RLObjectAllValuesFromFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.RLObjectAllValuesFromImpl.class, OWL2.Restriction, OntClassImpl.RLObjectAllValuesFromImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Restriction)).and(RestrictionType.OBJECT.getFilter()).and((n, g) -> {
            try (ExtendedIterator<Triple> res = g.asGraph().find(n, OWL2.allValuesFrom.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    Node node = ((Triple)res.next()).getObject();
                    OntClass clazz = OntEnhGraph.asPersonalityModel(g).safeFindNodeAs(node, OntClass.class);
                    if (clazz == null || !clazz.canAsSuperClass()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return OntEnhNodeFactories.createCommon(maker, RESTRICTION_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2QLIntersectionOfFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.QLIntersectionOfImpl.class, OWL2.Class, OntClassImpl.QLIntersectionOfImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Class)).and((n, g) -> {
            try (ExtendedIterator<Triple> res = g.asGraph().find(n, OWL2.intersectionOf.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    Node listNode = ((Triple)res.next()).getObject();
                    if (!STDObjectFactories.RDF_LIST.canWrap(listNode, g)) {
                        boolean bl = false;
                        return bl;
                    }
                    RDFList list = (RDFList)((Object)STDObjectFactories.RDF_LIST.wrap(listNode, g));
                    if (!Iterators.hasAtLeast(list.iterator().mapWith(it -> OntEnhGraph.asPersonalityModel(g).safeFindNodeAs(it.asNode(), OntClass.class)).filterKeep(it -> it != null && it.canAsSuperClass()), 2)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return OntEnhNodeFactories.createCommon(maker, CLASS_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2RLIntersectionOfFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.RLIntersectionOfImpl.class, OWL2.Class, OntClassImpl.RLIntersectionOfImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Class)).and((n, g) -> {
            try (ExtendedIterator<Triple> res = g.asGraph().find(n, OWL2.intersectionOf.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    Node listNode = ((Triple)res.next()).getObject();
                    if (!STDObjectFactories.RDF_LIST.canWrap(listNode, g)) {
                        boolean bl = false;
                        return bl;
                    }
                    RDFList list = (RDFList)((Object)STDObjectFactories.RDF_LIST.wrap(listNode, g));
                    ExtendedIterator<RDFNode> members = list.iterator();
                    int numSub = 0;
                    int numSup = 0;
                    int numEqv = 0;
                    try {
                        while (members.hasNext()) {
                            RDFNode e2 = (RDFNode)members.next();
                            OntClass clazz = OntEnhGraph.asPersonalityModel(g).safeFindNodeAs(e2.asNode(), OntClass.class);
                            if (clazz == null) continue;
                            if (clazz.canAsSubClass()) {
                                ++numSub;
                            }
                            if (clazz.canAsSuperClass()) {
                                ++numSup;
                            }
                            if (clazz.canAsEquivalentClass()) {
                                ++numEqv;
                            }
                            if (numSub <= 1 && numSup <= 1 && numEqv <= 1) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    finally {
                        members.close();
                    }
                }
            }
            return false;
        });
        return OntEnhNodeFactories.createCommon(maker, CLASS_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2RLComplementOfFactory(OntConfig config) {
        return OntClasses.createOWL2RLQLComplementOfFactory(config, OntClassImpl.RLComplementOfImpl.class, OntClassImpl.RLComplementOfImpl::new);
    }

    public static EnhNodeFactory createOWL2QLComplementOfFactory(OntConfig config) {
        return OntClasses.createOWL2RLQLComplementOfFactory(config, OntClassImpl.QLComplementOfImpl.class, OntClassImpl.QLComplementOfImpl::new);
    }

    private static EnhNodeFactory createOWL2RLQLComplementOfFactory(OntConfig config, Class<? extends OntClassImpl> implType, BiFunction<Node, EnhGraph, EnhNode> producer) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(implType, OWL2.Class, producer);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Class)).and((n, g) -> {
            try (ExtendedIterator<Triple> res = g.asGraph().find(n, OWL2.complementOf.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    Node node = ((Triple)res.next()).getObject();
                    OntClass clazz = OntEnhGraph.asPersonalityModel(g).safeFindNodeAs(node, OntClass.class);
                    if (clazz == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!clazz.canAsSubClass()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return OntEnhNodeFactories.createCommon(maker, CLASS_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2RLUnionOfFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.RLUnionOfImpl.class, OWL2.Class, OntClassImpl.RLUnionOfImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Class)).and((n, g) -> {
            try (ExtendedIterator<Triple> res = g.asGraph().find(n, OWL2.unionOf.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    Node listNode = ((Triple)res.next()).getObject();
                    if (!STDObjectFactories.RDF_LIST.canWrap(listNode, g)) {
                        boolean bl = false;
                        return bl;
                    }
                    RDFList list = (RDFList)((Object)STDObjectFactories.RDF_LIST.wrap(listNode, g));
                    if (!Iterators.hasAtLeast(list.iterator().mapWith(it -> OntEnhGraph.asPersonalityModel(g).safeFindNodeAs(it.asNode(), OntClass.class)).filterKeep(it -> it != null && it.canAsSubClass()), 2)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return OntEnhNodeFactories.createCommon(maker, CLASS_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2RLObjectMaxCardinalityFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.RLObjectMaxCardinalityImpl.class, OWL2.Restriction, OntClassImpl.RLObjectMaxCardinalityImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Restriction)).and(RestrictionType.OBJECT.getFilter()).and((n, g) -> {
            try (ExtendedIterator<Triple> byMaxQualifiedCardinality = g.asGraph().find(n, OWL2.maxQualifiedCardinality.asNode(), Node.ANY);){
                while (byMaxQualifiedCardinality.hasNext()) {
                    Node cardinality = ((Triple)byMaxQualifiedCardinality.next()).getObject();
                    if (!OntClasses.isZeroOrOneNonNegativeInteger(cardinality)) continue;
                    if (!Iterators.anyMatch(g.asGraph().find(n, OWL2.onClass.asNode(), Node.ANY), it -> OntEnhGraph.asPersonalityModel(g).safeFindNodeAs(it.getObject(), OntClass.class).canAsSubClass())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return Iterators.anyMatch(g.asGraph().find(n, OWL2.maxCardinality.asNode(), Node.ANY).mapWith(Triple::getObject), OntClasses::isZeroOrOneNonNegativeInteger);
        });
        return OntEnhNodeFactories.createCommon(maker, RESTRICTION_FINDER, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createOWL2RLDataMaxCardinalityFactory(OntConfig config) {
        EnhNodeProducer.WithType maker = new EnhNodeProducer.WithType(OntClassImpl.RLDataMaxCardinalityImpl.class, OWL2.Restriction, OntClassImpl.RLDataMaxCardinalityImpl::new);
        EnhNodeFilter primary = config.getBoolean(OntModelControls.ALLOW_NAMED_CLASS_EXPRESSIONS) ? EnhNodeFilter.TRUE : EnhNodeFilter.ANON;
        EnhNodeFilter filter = primary.and(new EnhNodeFilter.HasType(OWL2.Restriction)).and(RestrictionType.DATA.getFilter()).and((n, g) -> {
            try (ExtendedIterator<Triple> byMaxQualifiedCardinality = g.asGraph().find(n, OWL2.maxQualifiedCardinality.asNode(), Node.ANY);){
                while (byMaxQualifiedCardinality.hasNext()) {
                    Node cardinality = ((Triple)byMaxQualifiedCardinality.next()).getObject();
                    if (!OntClasses.isZeroOrOneNonNegativeInteger(cardinality)) continue;
                    if (!Iterators.anyMatch(g.asGraph().find(n, OWL2.onDataRange.asNode(), Node.ANY).mapWith(it -> OntEnhGraph.asPersonalityModel(g).findNodeAs(it.getObject(), OntDataRange.class)), Objects::nonNull)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return Iterators.anyMatch(g.asGraph().find(n, OWL2.maxCardinality.asNode(), Node.ANY).mapWith(Triple::getObject), OntClasses::isZeroOrOneNonNegativeInteger);
        });
        return OntEnhNodeFactories.createCommon(maker, RESTRICTION_FINDER, filter, new EnhNodeFilter[0]);
    }

    private static boolean isZeroOrOneNonNegativeInteger(Node n) {
        if (!n.isLiteral() || !n.getLiteral().getDatatypeURI().equals(XSD.nonNegativeInteger.getURI())) {
            return false;
        }
        String value = n.getLiteral().getValue().toString();
        return "0".equals(value) || "1".equals(value);
    }

    public static enum Type implements BiFunction<Node, EnhGraph, EnhNode>
    {
        OBJECT_SOME_VALUES_FROM(OntClass.ObjectSomeValuesFrom.class),
        OBJECT_ALL_VALUES_FROM(OntClass.ObjectAllValuesFrom.class),
        OBJECT_MIN_CARDINALITY(OntClass.ObjectMinCardinality.class),
        OBJECT_MAX_CARDINALITY(OntClass.ObjectMaxCardinality.class),
        OBJECT_EXACT_CARDINALITY(OntClass.ObjectCardinality.class),
        OBJECT_HAS_VALUE(OntClass.ObjectHasValue.class),
        OBJECT_HAS_SELF(OntClass.HasSelf.class),
        DATA_SOME_VALUES_FROM(OntClass.DataSomeValuesFrom.class),
        DATA_ALL_VALUES_FROM(OntClass.DataAllValuesFrom.class),
        DATA_MIN_CARDINALITY(OntClass.DataMinCardinality.class),
        DATA_MAX_CARDINALITY(OntClass.DataMaxCardinality.class),
        DATA_EXACT_CARDINALITY(OntClass.DataCardinality.class),
        DATA_HAS_VALUE(OntClass.DataHasValue.class),
        DATA_NARY_SOME_VALUES_FROM(OntClass.NaryDataSomeValuesFrom.class),
        DATA_NARY_ALL_VALUES_FROM(OntClass.NaryDataAllValuesFrom.class),
        UNION_OF(OntClass.UnionOf.class),
        INTERSECTION_OF(OntClass.IntersectionOf.class),
        ONE_OF(OntClass.OneOf.class),
        COMPLEMENT_OF(OntClass.ComplementOf.class);

        private final EnhNodeFactory factory;

        private Type(Class<? extends OntObject> type) {
            this.factory = WrappedEnhNodeFactory.of(type);
        }

        @Override
        public EnhNode apply(Node node, EnhGraph enhGraph) {
            return this.factory.createInstance(node, enhGraph);
        }
    }

    static class Factory
    extends BaseEnhNodeFactoryImpl {
        private static final Implementation LIST_FACTORY = STDObjectFactories.RDF_LIST;
        private static final Node ANY = Node.ANY;
        private static final Node TYPE = RDF.Nodes.type;
        private static final Node CLASS = OWL2.Class.asNode();
        private static final Node RESTRICTION = OWL2.Restriction.asNode();
        private static final Node ON_PROPERTY = OWL2.onProperty.asNode();
        private static final Node HAS_VALUE = OWL2.hasValue.asNode();
        private static final Node QUALIFIED_CARDINALITY = OWL2.qualifiedCardinality.asNode();
        private static final Node CARDINALITY = OWL2.cardinality.asNode();
        private static final Node MIN_QUALIFIED_CARDINALITY = OWL2.minQualifiedCardinality.asNode();
        private static final Node MIN_CARDINALITY = OWL2.minCardinality.asNode();
        private static final Node MAX_QUALIFIED_CARDINALITY = OWL2.maxQualifiedCardinality.asNode();
        private static final Node MAX_CARDINALITY = OWL2.maxCardinality.asNode();
        private static final Node SOME_VALUES_FROM = OWL2.someValuesFrom.asNode();
        private static final Node ALL_VALUES_FROM = OWL2.allValuesFrom.asNode();
        private static final Node ON_CLASS = OWL2.onClass.asNode();
        private static final Node ON_DATA_RANGE = OWL2.onDataRange.asNode();
        private static final Node HAS_SELF = OWL2.hasSelf.asNode();
        private static final Node ON_PROPERTIES = OWL2.onProperties.asNode();
        private static final Node INTERSECTION_OF = OWL2.intersectionOf.asNode();
        private static final Node UNION_OF = OWL2.unionOf.asNode();
        private static final Node ONE_OF = OWL2.oneOf.asNode();
        private static final Node COMPLEMENT_OF = OWL2.complementOf.asNode();
        private static final Node TRUE = NodeFactory.createLiteralByValue(Boolean.TRUE, XSDDatatype.XSDboolean);
        private static final String NON_NEGATIVE_INTEGER_URI = XSD.nonNegativeInteger.getURI();
        private static final BiFunction<Node, EnhGraph, EnhNode> GENERIC_CLASS_PRODUCER = OntSimpleClassImpl::new;
        private static final BiFunction<Node, EnhGraph, EnhNode> GENERIC_RESTRICTION_PRODUCER = OntClassImpl.RestrictionImpl::new;
        protected final EnhNodeFactory objectPropertyFactory = WrappedEnhNodeFactory.of(OntObjectProperty.class);
        protected final EnhNodeFactory dataPropertyFactory = WrappedEnhNodeFactory.of(OntDataProperty.class);
        private final boolean allowNamedClassExpressions;
        private final boolean allowQualifiedCardinalityRestrictions;
        private final Set<Type> filters;
        private final Set<Type> strict;
        private final BiFunction<Node, EnhGraph, EnhNode> namedClassProducer;
        private final BiPredicate<Node, EnhGraph> namedClassFilter;
        private final BiPredicate<Node, EnhGraph> genericClassFilter;

        private Factory(BiPredicate<Node, EnhGraph> namedClassFilter, BiPredicate<Node, EnhGraph> genericClassFilter, BiFunction<Node, EnhGraph, EnhNode> namedClassProducer, boolean allowNamedClassExpressions, boolean allowQualifiedCardinalityRestrictions, List<Type> filters, List<Type> additionalFilters) {
            if (genericClassFilter != null && namedClassFilter == null) {
                throw new IllegalArgumentException();
            }
            this.namedClassFilter = namedClassFilter;
            this.genericClassFilter = genericClassFilter;
            this.namedClassProducer = namedClassProducer;
            this.allowNamedClassExpressions = allowNamedClassExpressions;
            this.allowQualifiedCardinalityRestrictions = allowQualifiedCardinalityRestrictions;
            this.filters = EnumSet.copyOf(filters);
            this.strict = additionalFilters.isEmpty() ? Set.of() : EnumSet.copyOf(additionalFilters);
        }

        private boolean isDataCardinality(Node n, EnhGraph eg, Node p, Node qp) {
            return Factory.isCardinality(n, eg, p) || this.allowQualifiedCardinalityRestrictions && Factory.isQualifiedCardinality(n, eg, qp, ON_DATA_RANGE, OntDataRange.class);
        }

        private boolean isObjectCardinality(Node n, EnhGraph eg, Node p, Node qp) {
            return Factory.isCardinality(n, eg, p) || this.allowQualifiedCardinalityRestrictions && Factory.isQualifiedCardinality(n, eg, qp, ON_CLASS, OntClass.class);
        }

        private static boolean isQualifiedCardinality(Node n, EnhGraph eg, Node p, Node o, Class<? extends OntObject> t) {
            return Factory.isCardinality(n, eg, p) && Factory.isObjectOfType(n, eg, o, t);
        }

        private static boolean isCardinality(Node n, EnhGraph eg, Node p) {
            return Iterators.findFirst(Factory.listObjects(n, eg, p).filterKeep(x -> Factory.isLiteral(x.getObject(), NON_NEGATIVE_INTEGER_URI))).isPresent();
        }

        private static boolean isList(Node n, EnhGraph eg, Node p) {
            return Iterators.findFirst(Factory.listObjects(n, eg, p).filterKeep(x -> LIST_FACTORY.canWrap(x.getObject(), eg))).isPresent();
        }

        private static boolean isLiteral(Node n, String dt) {
            return n.isLiteral() && dt.equals(n.getLiteralDatatypeURI());
        }

        private static boolean isObjectOfType(Node n, EnhGraph eg, Node p, Class<? extends OntObject> t) {
            return Iterators.findFirst(Factory.listObjects(n, eg, p).filterKeep(x -> Factory.hasType(x.getObject(), eg, t))).isPresent();
        }

        private static boolean hasType(Node n, EnhGraph eg, Class<? extends OntObject> type) {
            return OntEnhGraph.canAs(type, n, eg);
        }

        private static ExtendedIterator<Triple> listObjects(Node n, EnhGraph eg, Node p) {
            return eg.asGraph().find(n, p, ANY);
        }

        @Override
        public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
            ExtendedIterator<EnhNode> byOWLClass = null;
            if (this.filterDeclaredClassExpressions()) {
                byOWLClass = eg.asGraph().find(ANY, RDF.Nodes.type, CLASS).mapWith(t -> {
                    Node n = t.getSubject();
                    if (this.namedClassFilter != null && n.isURI()) {
                        return this.namedClassFilter.test(n, eg) ? this.namedClassProducer.apply(n, eg) : null;
                    }
                    if (this.genericClassFilter != null) {
                        return GENERIC_CLASS_PRODUCER.apply(n, eg);
                    }
                    BiFunction<Node, EnhGraph, EnhNode> res = null;
                    if ((!n.isURI() || this.allowNamedClassExpressions) && this.filterLogicalExpressions()) {
                        res = this.logicalExpressionFactory(n, eg);
                    }
                    if (res != null) {
                        return res.apply(n, eg);
                    }
                    return null;
                }).filterKeep(Objects::nonNull);
            }
            ExtendedIterator<EnhNode> byOWLRestriction = null;
            if (this.filterRestrictions()) {
                byOWLRestriction = eg.asGraph().find(ANY, RDF.Nodes.type, RESTRICTION).mapWith(t -> {
                    Node n = t.getSubject();
                    if (n.isURI() && !this.allowNamedClassExpressions) {
                        return null;
                    }
                    if (this.genericClassFilter != null) {
                        return GENERIC_RESTRICTION_PRODUCER.apply(n, eg);
                    }
                    BiFunction<Node, EnhGraph, EnhNode> res = this.restrictionFactory(n, eg);
                    if (res != null) {
                        return res.apply(n, eg);
                    }
                    return null;
                }).filterKeep(Objects::nonNull);
            }
            if (byOWLClass == null && byOWLRestriction == null) {
                return NullIterator.instance();
            }
            if (byOWLClass != null && byOWLRestriction != null) {
                return byOWLClass.andThen(byOWLRestriction);
            }
            if (byOWLClass == null) {
                return byOWLRestriction;
            }
            return byOWLClass;
        }

        @Override
        public EnhNode createInstance(Node node, EnhGraph eg) {
            BiFunction<Node, EnhGraph, EnhNode> f = this.map(node, eg);
            if (f == null) {
                return null;
            }
            return f.apply(node, eg);
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return this.map(node, eg) != null;
        }

        @Override
        public EnhNode wrap(Node node, EnhGraph eg) throws OntJenaException {
            BiFunction<Node, EnhGraph, EnhNode> f = this.map(node, eg);
            if (f == null) {
                throw new OntJenaException.Conversion("Can't convert node " + node + " to Class Expression.");
            }
            EnhNode res = f.apply(node, eg);
            if (res == null) {
                throw new OntJenaException.IllegalState("Can't create Class Expression for node " + node);
            }
            return res;
        }

        private BiFunction<Node, EnhGraph, EnhNode> map(Node n, EnhGraph eg) {
            if (n.isLiteral()) {
                return null;
            }
            if (this.namedClassFilter != null && n.isURI()) {
                return this.namedClassFilter.test(n, eg) ? this.namedClassProducer : null;
            }
            Graph g = eg.asGraph();
            if (this.filterRestrictions() && g.contains(n, TYPE, RESTRICTION)) {
                if (n.isURI() && !this.allowNamedClassExpressions) {
                    return null;
                }
                return this.restrictionFactory(n, eg);
            }
            if (this.filterLogicalExpressions() && g.contains(n, TYPE, CLASS)) {
                BiFunction<Node, EnhGraph, EnhNode> res = null;
                if ((!n.isURI() || this.allowNamedClassExpressions) && this.filterLogicalExpressions()) {
                    res = this.logicalExpressionFactory(n, eg);
                }
                if (res != null) {
                    return res;
                }
                if (this.genericClassFilter != null) {
                    return GENERIC_CLASS_PRODUCER;
                }
                return null;
            }
            if (this.genericClassFilter != null) {
                return this.genericClassFilter.test(n, eg) ? GENERIC_CLASS_PRODUCER : null;
            }
            return null;
        }

        private BiFunction<Node, EnhGraph, EnhNode> restrictionFactory(Node n, EnhGraph eg) {
            BiFunction<Node, EnhGraph, EnhNode> res;
            if (this.filterUnaryRestrictions() && (res = this.unaryRestrictionFactory(n, eg)) != null) {
                return res;
            }
            if (this.filterNaryRestrictions() && eg.asGraph().contains(n, ON_PROPERTIES, ANY)) {
                if (this.filters.contains(Type.DATA_NARY_SOME_VALUES_FROM) && Iterators.findFirst(Factory.listObjects(n, eg, SOME_VALUES_FROM)).isPresent()) {
                    return Type.DATA_NARY_SOME_VALUES_FROM;
                }
                if (this.filters.contains(Type.DATA_NARY_ALL_VALUES_FROM) && Iterators.findFirst(Factory.listObjects(n, eg, ALL_VALUES_FROM)).isPresent()) {
                    return Type.DATA_NARY_ALL_VALUES_FROM;
                }
            }
            if (this.genericClassFilter != null) {
                return GENERIC_RESTRICTION_PRODUCER;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BiFunction<Node, EnhGraph, EnhNode> unaryRestrictionFactory(Node n, EnhGraph eg) {
            try (ExtendedIterator<Node> props = Factory.listObjects(n, eg, ON_PROPERTY).mapWith(Triple::getObject);){
                boolean onPropertyFound = false;
                while (props.hasNext()) {
                    onPropertyFound = true;
                    Node p = (Node)props.next();
                    if (this.filterObjectUnaryRestrictions() && this.objectPropertyFactory.canWrap(p, eg)) {
                        if (this.filters.contains(Type.OBJECT_SOME_VALUES_FROM) && Factory.isObjectOfType(n, eg, SOME_VALUES_FROM, OntClass.class)) {
                            Type type = this.strictFilter(n, eg, Type.OBJECT_SOME_VALUES_FROM);
                            return type;
                        }
                        if (this.filters.contains(Type.OBJECT_ALL_VALUES_FROM) && Factory.isObjectOfType(n, eg, ALL_VALUES_FROM, OntClass.class)) {
                            Type type = this.strictFilter(n, eg, Type.OBJECT_ALL_VALUES_FROM);
                            return type;
                        }
                        if (this.filters.contains(Type.OBJECT_HAS_VALUE) && Factory.isObjectOfType(n, eg, HAS_VALUE, OntIndividual.class)) {
                            Type type = Type.OBJECT_HAS_VALUE;
                            return type;
                        }
                        if (this.filters.contains(Type.OBJECT_MIN_CARDINALITY) && this.isObjectCardinality(n, eg, MIN_CARDINALITY, MIN_QUALIFIED_CARDINALITY)) {
                            Type type = Type.OBJECT_MIN_CARDINALITY;
                            return type;
                        }
                        if (this.filters.contains(Type.OBJECT_MAX_CARDINALITY) && this.isObjectCardinality(n, eg, MAX_CARDINALITY, MAX_QUALIFIED_CARDINALITY)) {
                            Type type = this.strictFilter(n, eg, Type.OBJECT_MAX_CARDINALITY);
                            return type;
                        }
                        if (this.filters.contains(Type.OBJECT_EXACT_CARDINALITY) && this.isObjectCardinality(n, eg, CARDINALITY, QUALIFIED_CARDINALITY)) {
                            Type type = Type.OBJECT_EXACT_CARDINALITY;
                            return type;
                        }
                        if (this.filters.contains(Type.OBJECT_HAS_SELF) && Iterators.findFirst(Factory.listObjects(n, eg, HAS_SELF).filterKeep(x -> TRUE.equals(x.getObject()))).isPresent()) {
                            Type type = Type.OBJECT_HAS_SELF;
                            return type;
                        }
                    }
                    if (!this.filterDataUnaryRestrictions() || !this.dataPropertyFactory.canWrap(p, eg)) continue;
                    if (this.filters.contains(Type.DATA_SOME_VALUES_FROM) && Factory.isObjectOfType(n, eg, SOME_VALUES_FROM, OntDataRange.class)) {
                        Type type = Type.DATA_SOME_VALUES_FROM;
                        return type;
                    }
                    if (this.filters.contains(Type.DATA_ALL_VALUES_FROM) && Factory.isObjectOfType(n, eg, ALL_VALUES_FROM, OntDataRange.class)) {
                        Type type = Type.DATA_ALL_VALUES_FROM;
                        return type;
                    }
                    if (this.filters.contains(Type.DATA_HAS_VALUE) && Iterators.findFirst(Factory.listObjects(n, eg, HAS_VALUE).filterKeep(x -> x.getObject().isLiteral())).isPresent()) {
                        Type type = Type.DATA_HAS_VALUE;
                        return type;
                    }
                    if (this.filters.contains(Type.DATA_MIN_CARDINALITY) && this.isDataCardinality(n, eg, MIN_CARDINALITY, MIN_QUALIFIED_CARDINALITY)) {
                        Type type = Type.DATA_MIN_CARDINALITY;
                        return type;
                    }
                    if (this.filters.contains(Type.DATA_MAX_CARDINALITY) && this.isDataCardinality(n, eg, MAX_CARDINALITY, MAX_QUALIFIED_CARDINALITY)) {
                        Type type = this.strictFilter(n, eg, Type.DATA_MAX_CARDINALITY);
                        return type;
                    }
                    if (!this.filters.contains(Type.DATA_EXACT_CARDINALITY) || !this.isDataCardinality(n, eg, CARDINALITY, QUALIFIED_CARDINALITY)) continue;
                    Type type = Type.DATA_EXACT_CARDINALITY;
                    return type;
                }
                if (onPropertyFound && this.genericClassFilter != null) {
                    BiFunction<Node, EnhGraph, EnhNode> biFunction = GENERIC_RESTRICTION_PRODUCER;
                    return biFunction;
                }
            }
            return null;
        }

        private BiFunction<Node, EnhGraph, EnhNode> logicalExpressionFactory(Node n, EnhGraph eg) {
            if (this.filters.contains(Type.COMPLEMENT_OF) && Factory.isObjectOfType(n, eg, COMPLEMENT_OF, OntClass.class)) {
                return this.strictFilter(n, eg, Type.COMPLEMENT_OF);
            }
            if (this.filters.contains(Type.INTERSECTION_OF) && Factory.isList(n, eg, INTERSECTION_OF)) {
                return this.strictFilter(n, eg, Type.INTERSECTION_OF);
            }
            if (this.filters.contains(Type.UNION_OF) && Factory.isList(n, eg, UNION_OF)) {
                return this.strictFilter(n, eg, Type.UNION_OF);
            }
            if (this.filters.contains(Type.ONE_OF) && Factory.isList(n, eg, ONE_OF)) {
                return this.strictFilter(n, eg, Type.ONE_OF);
            }
            return null;
        }

        private Type strictFilter(Node n, EnhGraph eg, Type filter) {
            return this.strict.contains(filter) ? (filter.factory.canWrap(n, eg) ? filter : null) : filter;
        }

        private boolean filterDeclaredClassExpressions() {
            return this.namedClassFilter != null || this.filterLogicalExpressions();
        }

        private boolean filterLogicalExpressions() {
            return this.filters.contains(Type.COMPLEMENT_OF) || this.filterCollectionOfExpressions();
        }

        private boolean filterCollectionOfExpressions() {
            return this.filters.contains(Type.UNION_OF) || this.filters.contains(Type.INTERSECTION_OF) || this.filters.contains(Type.ONE_OF);
        }

        private boolean filterRestrictions() {
            return this.filterUnaryRestrictions() || this.filterNaryRestrictions();
        }

        private boolean filterUnaryRestrictions() {
            return this.filterObjectUnaryRestrictions() || this.filterDataUnaryRestrictions() || this.filters.contains(Type.OBJECT_HAS_SELF);
        }

        private boolean filterObjectUnaryRestrictions() {
            return this.filters.contains(Type.OBJECT_ALL_VALUES_FROM) || this.filters.contains(Type.OBJECT_SOME_VALUES_FROM) || this.filters.contains(Type.OBJECT_HAS_VALUE) || this.filters.contains(Type.OBJECT_MIN_CARDINALITY) || this.filters.contains(Type.OBJECT_EXACT_CARDINALITY) || this.filters.contains(Type.OBJECT_MAX_CARDINALITY) || this.filters.contains(Type.OBJECT_HAS_SELF);
        }

        private boolean filterDataUnaryRestrictions() {
            return this.filters.contains(Type.DATA_ALL_VALUES_FROM) || this.filters.contains(Type.DATA_SOME_VALUES_FROM) || this.filters.contains(Type.DATA_HAS_VALUE) || this.filters.contains(Type.DATA_MIN_CARDINALITY) || this.filters.contains(Type.DATA_EXACT_CARDINALITY) || this.filters.contains(Type.DATA_MAX_CARDINALITY);
        }

        private boolean filterNaryRestrictions() {
            return this.filters.contains(Type.DATA_NARY_ALL_VALUES_FROM) || this.filters.contains(Type.DATA_SOME_VALUES_FROM);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ObjectRestrictionType implements PredicateFilterProvider
    {
        NAMED_CLASS{

            public Class<OntClass.Named> view() {
                return OntClass.Named.class;
            }
        }
        ,
        CLASS{

            public Class<OntClass> view() {
                return OntClass.class;
            }
        }
        ,
        DATA_RANGE{

            public Class<OntDataRange> view() {
                return OntDataRange.class;
            }
        }
        ,
        INDIVIDUAL{

            public Class<OntIndividual> view() {
                return OntIndividual.class;
            }
        }
        ,
        LITERAL{

            public Class<Literal> view() {
                return Literal.class;
            }

            @Override
            public boolean testObject(Node node, EnhGraph graph) {
                return node.isLiteral();
            }
        };

    }

    public static enum RestrictionType implements PredicateFilterProvider
    {
        DATA(OntDataProperty.class),
        OBJECT(OntObjectProperty.class);

        private final Class<? extends OntProperty> type;
        private final EnhNodeFactory propertyFactory;

        private RestrictionType(Class<? extends OntProperty> type) {
            this.type = type;
            this.propertyFactory = WrappedEnhNodeFactory.of(type);
        }

        public Class<? extends OntProperty> view() {
            return this.type;
        }

        public EnhNodeFilter getFilter() {
            return this.getFilter(OWL2.onProperty);
        }

        @Override
        public boolean testObject(Node node, EnhGraph graph) {
            return this.propertyFactory.canWrap(node, graph);
        }
    }

    public static class HasSelfMaker
    extends EnhNodeProducer.WithType {
        public HasSelfMaker() {
            super(OntClassImpl.HasSelfImpl.class, OWL2.Restriction);
        }

        @Override
        public void doInsert(Node node, EnhGraph eg) {
            super.doInsert(node, eg);
            eg.asGraph().add(Triple.create(node, OWL2.hasSelf.asNode(), StdModels.TRUE.asNode()));
        }
    }

    public static class HasSelfFilter
    implements EnhNodeFilter {
        @Override
        public boolean test(Node n, EnhGraph g) {
            return g.asGraph().contains(n, OWL2.hasSelf.asNode(), StdModels.TRUE.asNode());
        }
    }

    private static interface PredicateFilterProvider {
        public Class<? extends RDFNode> view();

        default public EnhNodeFilter getFilter(Property predicate) {
            return (node, graph) -> this.testObjects(predicate, node, graph);
        }

        default public boolean testObjects(Property predicate, Node node, EnhGraph graph) {
            return Iterators.anyMatch(graph.asGraph().find(node, predicate.asNode(), Node.ANY), t -> this.testObject(t.getObject(), graph));
        }

        default public boolean testObject(Node node, EnhGraph graph) {
            return OntEnhGraph.canAs(this.view(), node, graph);
        }
    }
}

