/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap;

import java.io.PrintStream;
import java.util.List;
import java.util.Queue;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.AsyncStatementInstance;
import org.eclipse.epsilon.eol.execute.context.ExtendedProperties;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.IntrospectionManager;
import org.eclipse.epsilon.eol.execute.operations.EolOperationFactory;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.IToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.userinput.IUserInput;

public class EvaluatorContext
implements IEolContext {
    private final IEolContext delegate;
    private ExecutorFactory executorFactory;
    private FrameStack frameStack;

    public EvaluatorContext(IEolContext context) {
        this.delegate = context;
        this.frameStack = context.getFrameStack().clone();
        this.executorFactory = new ExecutorFactory(context.getExecutorFactory());
    }

    public void setUserInput(IUserInput userInput) {
        this.delegate.setUserInput(userInput);
    }

    public IUserInput getUserInput() {
        return this.delegate.getUserInput();
    }

    public PrettyPrinterManager getPrettyPrinterManager() {
        return this.delegate.getPrettyPrinterManager();
    }

    public void setPrettyPrinterManager(PrettyPrinterManager prettyPrinterManager) {
        this.delegate.setPrettyPrinterManager(prettyPrinterManager);
    }

    public PrintStream getOutputStream() {
        return this.delegate.getOutputStream();
    }

    public void setOutputStream(PrintStream outputStream) {
        this.delegate.getOutputStream();
    }

    public PrintStream getWarningStream() {
        return this.delegate.getWarningStream();
    }

    public void setWarningStream(PrintStream warningStream) {
        this.delegate.setWarningStream(warningStream);
    }

    public EolOperationFactory getOperationFactory() {
        return this.delegate.getOperationFactory();
    }

    public void setOperationFactory(EolOperationFactory operationFactory) {
        this.delegate.setOperationFactory(operationFactory);
    }

    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public ModelRepository getModelRepository() {
        return this.delegate.getModelRepository();
    }

    public void setModelRepository(ModelRepository modelRepository) {
        this.delegate.setModelRepository(modelRepository);
    }

    public FrameStack getFrameStack() {
        return this.frameStack;
    }

    public void setFrameStack(FrameStack scope) {
        this.frameStack = scope;
    }

    public IntrospectionManager getIntrospectionManager() {
        return this.delegate.getIntrospectionManager();
    }

    public void setIntrospectionManager(IntrospectionManager introspectionManager) {
        this.delegate.setIntrospectionManager(introspectionManager);
    }

    public PrintStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    public void setErrorStream(PrintStream defaultErrorStream) {
        this.delegate.setErrorStream(defaultErrorStream);
    }

    public void setModule(IModule module) {
        this.delegate.setModule(module);
    }

    public IModule getModule() {
        return this.delegate.getModule();
    }

    public void setNativeTypeDelegates(List<IToolNativeTypeDelegate> nativeTypeDelegates) {
        this.delegate.setNativeTypeDelegates(nativeTypeDelegates);
    }

    public List<IToolNativeTypeDelegate> getNativeTypeDelegates() {
        return this.delegate.getNativeTypeDelegates();
    }

    public boolean isProfilingEnabled() {
        return this.delegate.isProfilingEnabled();
    }

    public void setProfilingEnabled(boolean profilingEnabled) {
        this.delegate.setProfilingEnabled(profilingEnabled);
    }

    public boolean isAssertionsEnabled() {
        return this.delegate.isAssertionsEnabled();
    }

    public void setAssertionsEnabled(boolean assertionsEnabled) {
        this.delegate.setAssertionsEnabled(assertionsEnabled);
    }

    public ExtendedProperties getExtendedProperties() {
        return this.delegate.getExtendedProperties();
    }

    public void setExtendedProperties(ExtendedProperties properties) {
        this.delegate.setExtendedProperties(properties);
    }

    public void dispose() {
    }

    public Queue<AsyncStatementInstance> getAsyncStatementsQueue() {
        return this.delegate.getAsyncStatementsQueue();
    }

    public OperationContributorRegistry getOperationContributorRegistry() {
        return this.delegate.getOperationContributorRegistry();
    }
}

