/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.impl.HierarchySupport;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntClassImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDFS;

public abstract class OntPropertyImpl
extends OntObjectImpl
implements OntProperty {
    public OntPropertyImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static Stream<OntClass> declaringClasses(OntProperty property, boolean direct) {
        Set<OntClass> domains = HierarchySupport.allTreeNodesSetInclusive(() -> property.domains().filter(it -> it.canAs(OntClass.class)).map(it -> it.as(OntClass.class)).filter(it -> !OntPropertyImpl.isReservedOrBuiltin(it)), clazz -> OntClassImpl.explicitSubClasses(clazz).filter(it -> !OntPropertyImpl.isReservedOrBuiltin(it)));
        if (domains.isEmpty()) {
            if (!direct) {
                return property.getModel().ontObjects(OntClass.class).filter(it -> !OntPropertyImpl.isReservedOrBuiltin(it));
            }
            return property.getModel().hierarchyRoots();
        }
        return domains.stream().filter(clazz -> clazz.hasDeclaredProperty(property, direct));
    }

    public static <X extends OntProperty> Stream<X> subProperties(X property, Class<X> type, boolean direct) {
        Property reasonerProperty;
        if (direct && (reasonerProperty = OntPropertyImpl.reasonerProperty(property.getModel(), RDFS.subPropertyOf)) != null) {
            return OntPropertyImpl.explicitSubProperties(property, reasonerProperty, type).filter(x -> !property.equals(x));
        }
        return HierarchySupport.treeNodes(property, it -> OntPropertyImpl.explicitSubProperties(it, RDFS.subPropertyOf, type), direct, OntGraphModelImpl.configValue(property.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT));
    }

    public static <X extends OntProperty> Stream<X> superProperties(X property, Class<X> type, boolean direct) {
        Property reasonerProperty;
        if (direct && (reasonerProperty = OntPropertyImpl.reasonerProperty(property.getModel(), RDFS.subPropertyOf)) != null) {
            return OntPropertyImpl.explicitSuperProperties(property, reasonerProperty, type).filter(x -> !property.equals(x));
        }
        return HierarchySupport.treeNodes(property, it -> OntPropertyImpl.explicitSuperProperties(it, RDFS.subPropertyOf, type), direct, OntGraphModelImpl.configValue(property.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT));
    }

    public static <X extends OntProperty> boolean hasSuperProperty(X property, X candidateSuper, Class<X> type, boolean direct) {
        Property reasonerProperty;
        if (property.equals(candidateSuper)) {
            return true;
        }
        if (direct && (reasonerProperty = OntPropertyImpl.reasonerProperty(property.getModel(), RDFS.subPropertyOf)) != null) {
            return property.getModel().contains(property, reasonerProperty, candidateSuper);
        }
        return HierarchySupport.contains(property, candidateSuper, it -> OntPropertyImpl.explicitSuperProperties(it, RDFS.subPropertyOf, type), direct, OntGraphModelImpl.configValue(property.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT));
    }

    public static <X extends OntRelationalProperty> Stream<X> disjointProperties(OntGraphModelImpl m, Class<X> type, X property) {
        if (!OntGraphModelImpl.configValue(m, OntModelControls.USE_OWL2_PROPERTY_DISJOINT_WITH_FEATURE)) {
            return Stream.empty();
        }
        return property.objects(OWL2.propertyDisjointWith, type);
    }

    public static <X extends OntRelationalProperty> OntStatement addDisjointWith(OntGraphModelImpl m, X property, X other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL2_PROPERTY_DISJOINT_WITH_FEATURE, "owl:propertyDisjointWith");
        return property.addStatement(OWL2.propertyDisjointWith, other);
    }

    public static <X extends OntRelationalProperty> void removeDisjointWith(OntGraphModelImpl m, X property, Resource other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL2_PROPERTY_DISJOINT_WITH_FEATURE, "owl:propertyDisjointWith");
        property.remove(OWL2.propertyDisjointWith, other);
    }

    public static <X extends OntRelationalProperty> Stream<X> equivalentProperties(OntGraphModelImpl m, Class<X> type, X property) {
        if (!OntGraphModelImpl.configValue(m, OntModelControls.USE_OWL_PROPERTY_EQUIVALENT_FEATURE)) {
            return Stream.empty();
        }
        return property.objects(OWL2.equivalentProperty, type);
    }

    public static <X extends OntRelationalProperty> OntStatement addEquivalentProperty(OntGraphModelImpl m, X property, X other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL_PROPERTY_EQUIVALENT_FEATURE, "owl:equivalentProperty");
        return property.addStatement(OWL2.equivalentProperty, other);
    }

    public static <X extends OntRelationalProperty> void removeEquivalentProperty(OntGraphModelImpl m, X property, Resource other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL_PROPERTY_EQUIVALENT_FEATURE, "owl:equivalentProperty");
        property.remove(OWL2.equivalentProperty, other);
    }

    static <X extends OntProperty> Stream<X> explicitSubProperties(X property, Property predicate, Class<X> type) {
        return OntPropertyImpl.subjects(predicate, property, type);
    }

    static <X extends OntProperty> Stream<X> explicitSuperProperties(X property, Property predicate, Class<X> type) {
        return property.objects(predicate, type);
    }

    @Override
    public Property asProperty() {
        if (!this.isURIResource()) {
            throw new OntJenaException.IllegalState();
        }
        return this.as(Property.class);
    }
}

