/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views;

import java.util.ArrayList;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.exceptions.ESCertificateException;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.CertificateSelectionDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.NewRepositoryWizard;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class NewRepositoryWizardPageOne
extends WizardPage {
    private static final int DEFAULT_PORT = 8080;
    private Text name;
    private Text url;
    private Spinner port;
    private Combo certificateCombo;

    public NewRepositoryWizardPageOne() {
        super("Main");
        this.setTitle("Server Details");
        this.setDescription("Select the details for the new repository");
    }

    public void createControl(Composite parent) {
        block7: {
            NewRepositoryWizard wizard = (NewRepositoryWizard)this.getWizard();
            ESServer server = wizard.getServer();
            Composite composite = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 3;
            composite.setLayout((Layout)gl);
            new Label(composite, 0).setText("Name:");
            this.name = new Text(composite, 2048);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.name.setLayoutData((Object)gd);
            new Label(composite, 0).setText("URL:");
            this.url = new Text(composite, 2048);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.url.setLayoutData((Object)gd);
            new Label(composite, 0).setText("Port:");
            this.port = new Spinner(composite, 2048);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.port.setLayoutData((Object)gd);
            this.port.setValues(8080, 1, 999999, 0, 1, 10);
            this.setControl((Control)composite);
            new Label(composite, 0).setText("Certificate:");
            this.certificateCombo = new Combo(composite, 2048);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            this.certificateCombo.setLayoutData((Object)gd);
            this.certificateCombo.setBackground(Display.getCurrent().getSystemColor(1));
            this.initCombo();
            Button button = new Button(composite, 0);
            button.setText("Edit");
            button.addSelectionListener((SelectionListener)new SelectionDialogListener());
            gd = new GridData(128);
            gd.horizontalSpan = 1;
            button.setLayoutData((Object)gd);
            if (server.getURL() != null) {
                this.name.setText(server.getName());
                this.url.setText(server.getURL());
                this.port.setSelection(server.getPort());
                if (server.getCertificateAlias() == null) {
                    return;
                }
                try {
                    if (KeyStoreManager.getInstance().contains(server.getCertificateAlias())) {
                        int i = 0;
                        while (i < this.certificateCombo.getItemCount()) {
                            if (this.certificateCombo.getItem(i).equals(server.getCertificateAlias())) {
                                this.certificateCombo.select(i);
                                break block7;
                            }
                            ++i;
                        }
                        break block7;
                    }
                    this.certificateCombo.setText("");
                }
                catch (ESCertificateException eSCertificateException) {
                    this.certificateCombo.setText("");
                }
            }
        }
    }

    private void initCombo() {
        try {
            ArrayList certificates = KeyStoreManager.getInstance().getCertificates();
            this.certificateCombo.setItems(certificates.toArray(new String[certificates.size()]));
            NewRepositoryWizard wizard = (NewRepositoryWizard)this.getWizard();
            ESServer server = wizard.getServer();
            String selectedCertificate = server.getCertificateAlias();
            this.certificateCombo.select(certificates.indexOf(selectedCertificate));
        }
        catch (ESCertificateException e) {
            WorkspaceUtil.logException((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean canFlipToNextPage() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return NewRepositoryWizardPageOne.isTextNonEmpty(this.name.getText()) && NewRepositoryWizardPageOne.isTextNonEmpty(this.url.getText()) && this.isComboNotEmpty();
    }

    public ESServer getServer() {
        return ESServer.FACTORY.createServer(this.name.getText(), this.url.getText(), this.port.getSelection(), this.certificateCombo.getText());
    }

    private static boolean isTextNonEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    private boolean isComboNotEmpty() {
        String s = this.certificateCombo.getItem(this.certificateCombo.getSelectionIndex());
        return NewRepositoryWizardPageOne.isTextNonEmpty(s);
    }

    class SelectionDialogListener
    implements SelectionListener {
        SelectionDialogListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CertificateSelectionDialog csd = new CertificateSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof String) {
                        return element.toString();
                    }
                    return "";
                }
            });
            try {
                ArrayList certificates = KeyStoreManager.getInstance().getCertificates();
                csd.setElements(certificates.toArray());
            }
            catch (ESCertificateException e1) {
                csd.setErrorMessage(e1.getMessage());
            }
            csd.setBlockOnOpen(true);
            csd.setTitle("Certificate Selection Dialog");
            csd.open();
            if (csd.getReturnCode() == 0) {
                NewRepositoryWizardPageOne.this.initCombo();
                int i = 0;
                while (i < NewRepositoryWizardPageOne.this.certificateCombo.getItemCount()) {
                    String item = NewRepositoryWizardPageOne.this.certificateCombo.getItem(i);
                    if (item.equals(csd.getCertificateAlias())) {
                        NewRepositoryWizardPageOne.this.certificateCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }
}

