/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.connection.xmlrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.EmfStoreController;
import org.eclipse.emf.emfstore.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.connection.ServerKeyStoreManager;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.util.EObjectTypeConverterFactory;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.util.EObjectTypeFactory;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.ServerKeyStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlRpcWebserverManager {
    private static XmlRpcWebserverManager instance;
    private WebServer webServer;
    private final int port;

    private XmlRpcWebserverManager() {
        int tmp = 8080;
        try {
            tmp = Integer.valueOf(ServerConfiguration.getProperties().getProperty("emfstore.connection.xmlrpc.port"));
        }
        catch (NumberFormatException e) {
            tmp = Integer.valueOf("8080");
        }
        this.port = tmp;
    }

    public static XmlRpcWebserverManager getInstance() {
        if (instance == null) {
            instance = new XmlRpcWebserverManager();
        }
        return instance;
    }

    public void initServer() throws FatalEmfStoreException {
        if (this.webServer != null) {
            return;
        }
        try {
            this.webServer = new WebServer(this.port){

                protected ServerSocket createServerSocket(int pPort, int backlog, InetAddress addr) throws IOException {
                    SSLServerSocketFactory serverSocketFactory = null;
                    try {
                        SSLContext context = SSLContext.getInstance("TLS");
                        context.init(ServerKeyStoreManager.getInstance().getKeyManagerFactory().getKeyManagers(), null, null);
                        serverSocketFactory = context.getServerSocketFactory();
                    }
                    catch (NoSuchAlgorithmException e) {
                        ModelUtil.logException((String)"Couldn't initialize server socket.", (Throwable)e);
                        EmfStoreController.getInstance().shutdown(new FatalEmfStoreException());
                    }
                    catch (KeyManagementException e) {
                        ModelUtil.logException((String)"Couldn't initialize server socket.", (Throwable)e);
                        EmfStoreController.getInstance().shutdown(new FatalEmfStoreException());
                    }
                    catch (ServerKeyStoreException e) {
                        ModelUtil.logException((String)"Couldn't initialize server socket.", (Throwable)e);
                        EmfStoreController.getInstance().shutdown(new FatalEmfStoreException());
                    }
                    return serverSocketFactory.createServerSocket(pPort, backlog, addr);
                }
            };
            ModelUtil.logInfo((String)("Started XML RPC Webserver on port: " + this.port));
            XmlRpcStreamServer xmlRpcServer = this.webServer.getXmlRpcServer();
            xmlRpcServer.setTypeFactory((TypeFactory)new EObjectTypeFactory((XmlRpcController)xmlRpcServer));
            EObjectTypeConverterFactory pFactory = new EObjectTypeConverterFactory();
            xmlRpcServer.setTypeConverterFactory((TypeConverterFactory)pFactory);
            PropertyHandlerMapping phm = new PropertyHandlerMapping();
            phm.setVoidMethodEnabled(true);
            phm.setTypeConverterFactory((TypeConverterFactory)pFactory);
            xmlRpcServer.setHandlerMapping((XmlRpcHandlerMapping)phm);
            XmlRpcServerConfigImpl serverConfig = (XmlRpcServerConfigImpl)xmlRpcServer.getConfig();
            serverConfig.setEnabledForExtensions(true);
            serverConfig.setEnabledForExceptions(true);
            serverConfig.setContentLengthOptional(false);
            this.webServer.start();
        }
        catch (IOException e) {
            throw new FatalEmfStoreException("Couldn't start webserver", e);
        }
    }

    public void addHandler(String handlerName, Class<?> clazz) throws FatalEmfStoreException {
        try {
            PropertyHandlerMapping mapper = (PropertyHandlerMapping)this.webServer.getXmlRpcServer().getHandlerMapping();
            mapper.addHandler(handlerName, clazz);
        }
        catch (XmlRpcException e) {
            throw new FatalEmfStoreException("Couldn't add handler", e);
        }
    }

    public boolean removeHandler(String handlerName) {
        PropertyHandlerMapping mapper = (PropertyHandlerMapping)this.webServer.getXmlRpcServer().getHandlerMapping();
        mapper.removeHandler(handlerName);
        try {
            return mapper.getListMethods().length > 0;
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    public void stopServer() {
        this.webServer.shutdown();
        this.webServer = null;
    }
}

