/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.backchannel.connection.server;

import org.eclipse.emf.emfstore.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.server.backchannel.BackchannelInterface;
import org.eclipse.emf.emfstore.server.backchannel.connection.server.XmlRpcBackchannelImpl;
import org.eclipse.emf.emfstore.server.connection.ConnectionHandler;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.XmlRpcWebserverManager;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcBackchannelConnectionHandler
implements ConnectionHandler<BackchannelInterface> {
    public static final String BACKCHANNEL = "Backchannel";
    private static final String NAME = "XML RPC Connection Handler for the Backchannel";
    private static AuthenticationControl accessControl;
    private static BackchannelInterface backchannelImpl;

    public String getName() {
        return NAME;
    }

    public void init(BackchannelInterface backchannel, AuthenticationControl accessControl) throws FatalEmfStoreException {
        backchannelImpl = backchannel;
        XmlRpcBackchannelConnectionHandler.accessControl = accessControl;
        XmlRpcWebserverManager webServer = XmlRpcWebserverManager.getInstance();
        webServer.initServer();
        webServer.addHandler(BACKCHANNEL, XmlRpcBackchannelImpl.class);
    }

    public static BackchannelInterface getBackChannel() {
        return backchannelImpl;
    }

    public static AuthenticationControl getAccessControl() {
        return accessControl;
    }

    public void stop(boolean force) {
        XmlRpcWebserverManager webserverManager = XmlRpcWebserverManager.getInstance();
        webserverManager.removeHandler(BACKCHANNEL);
    }
}

