/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge;

import java.util.ArrayList;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.ui.DecisionBox;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionConfig;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MergeWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "Resolve Conflicts";
    private ArrayList<DecisionBox> decisionBoxes;
    private DecisionManager decisionManager;

    protected MergeWizardPage(DecisionManager decisionManager) {
        super(PAGE_NAME);
        this.decisionManager = decisionManager;
        this.setTitle("Merge Conflicts");
        this.setDescription("Some of your changes conflict with changes from the repository.\nIn order to resolve these issues, select an option for every conflict.");
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite topBar = this.createTopBar(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)topBar);
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridDataFactory.fillDefaults().align(1, 1).grab(true, true).applyTo((Control)scrolledComposite);
        Composite client = new Composite((Composite)scrolledComposite, 0);
        client.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        client.setLayoutData((Object)gridData);
        ColorSwitcher colorSwitcher = new ColorSwitcher();
        this.decisionBoxes = new ArrayList();
        for (Conflict conflict : this.decisionManager.getConflicts()) {
            this.decisionBoxes.add(new DecisionBox(client, this.decisionManager, colorSwitcher.getColor(), conflict));
        }
        scrolledComposite.setContent((Control)client);
        Point computeSize = this.calcParentSize(parent);
        scrolledComposite.setMinSize(computeSize);
        this.setControl((Control)parent);
    }

    private Point calcParentSize(Composite parent) {
        Point computeSize = parent.computeSize(-1, -1);
        computeSize.x = parent.getBounds().width;
        computeSize.y += 50;
        return computeSize;
    }

    private Composite createTopBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        composite.setSize(-1, 200);
        Button accecptMine = new Button(composite, 8);
        accecptMine.setText("Keep All My Changes");
        accecptMine.addSelectionListener((SelectionListener)new SelectAllSelectionListener(ConflictOption.OptionType.MyOperation));
        Button accecptTheirs = new Button(composite, 8);
        accecptTheirs.setText("Keep All Their Changes");
        accecptTheirs.addSelectionListener((SelectionListener)new SelectAllSelectionListener(ConflictOption.OptionType.TheirOperation));
        return composite;
    }

    private final class ColorSwitcher {
        private boolean color = false;

        public Color getColor() {
            this.color = !this.color;
            return this.color ? DecisionConfig.getFirstDecisionBoxColor() : DecisionConfig.getSecondDecisionBoxColor();
        }
    }

    private final class SelectAllSelectionListener
    implements SelectionListener {
        private final ConflictOption.OptionType type;

        public SelectAllSelectionListener(ConflictOption.OptionType type) {
            this.type = type;
        }

        public void widgetSelected(SelectionEvent e) {
            this.select();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.select();
        }

        private void select() {
            block0: for (DecisionBox box : MergeWizardPage.this.decisionBoxes) {
                for (ConflictOption option : box.getConflict().getOptions()) {
                    if (!option.getType().equals((Object)this.type)) continue;
                    box.setSolution(option);
                    continue block0;
                }
            }
            if (!this.type.equals((Object)ConflictOption.OptionType.MyOperation)) {
                this.type.equals((Object)ConflictOption.OptionType.TheirOperation);
            }
        }
    }
}

