/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol;

import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.MultiAttributeControl;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

abstract class AttributeControl
implements ModifyListener,
MouseListener {
    private MultiAttributeControl parentItem;
    private Composite fieldComposite;
    private int index = -1;
    private ImageHyperlink button;
    private ImageHyperlink up;
    private ImageHyperlink down;

    AttributeControl() {
    }

    public void dispose() {
        this.fieldComposite.dispose();
    }

    protected void createDeleteButton() {
        this.setButton(new ImageHyperlink(this.getFieldComposite(), 128));
        this.getButton().setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.getButton().addMouseListener((MouseListener)this);
        this.getFieldComposite().layout();
    }

    protected void createAddButton() {
        this.setButton(new ImageHyperlink(this.getFieldComposite(), 128));
        this.getButton().setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.getButton().addMouseListener((MouseListener)this);
    }

    protected void createUpDownButtons() {
        Image up = Activator.getImageDescriptor("icons/arrow_up.png").createImage();
        Image down = Activator.getImageDescriptor("icons/arrow_down.png").createImage();
        if (this.getUp() != null) {
            this.getUp().dispose();
        }
        this.setUp(new ImageHyperlink(this.getFieldComposite(), 128));
        this.getUp().setImage(up);
        this.getUp().addMouseListener((MouseListener)this);
        if (this.getDown() != null) {
            this.getDown().dispose();
        }
        this.setDown(new ImageHyperlink(this.getFieldComposite(), 128));
        this.getDown().setImage(down);
        this.getDown().addMouseListener((MouseListener)this);
        this.getFieldComposite().layout();
    }

    protected void createInvisibleUpDownButtons() {
        this.setUp(new ImageHyperlink(this.getFieldComposite(), 128));
        this.getUp().setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        this.getUp().addMouseListener((MouseListener)this);
        this.getUp().setVisible(false);
        this.setDown(new ImageHyperlink(this.getFieldComposite(), 128));
        this.getDown().setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        this.getDown().addMouseListener((MouseListener)this);
        this.getDown().setVisible(false);
    }

    protected void createCompositeLayout() {
        this.setFieldComposite(this.getParentItem().getToolkit().createComposite(this.getParentItem().getComposite(), this.getParentItem().getStyle()));
        GridLayout fieldLayout = new GridLayout(4, false);
        fieldLayout.verticalSpacing = 0;
        this.getFieldComposite().setLayout((Layout)fieldLayout);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.getFieldComposite());
    }

    protected abstract boolean swapThisControlWith(int var1);

    public abstract void modifyText(ModifyEvent var1);

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        int index;
        if (e.getSource().equals(this.getButton())) {
            if (this.getIndex() == -1) {
                this.addButtonFunctionality();
            } else {
                if (this.getParentItem().isFull()) {
                    this.getParentItem().createSingleField();
                }
                this.removeElementAt(this.getIndex());
                int i = this.getIndex() + 1;
                while (i < this.getParentItem().getControlList().size()) {
                    AttributeControl c = this.getParentItem().getControlList().get(i);
                    c.setIndex(c.getIndex() - 1);
                    ++i;
                }
                this.getParentItem().getControlList().remove(this.getIndex());
                this.getFieldComposite().dispose();
            }
        }
        if (e.getSource().equals(this.getUp())) {
            index = this.getIndex();
            this.swapThisControlWith(index - 1);
            if (index > 0) {
                this.getParentItem().getControlList().get(index - 1).getUp().forceFocus();
            }
        }
        if (e.getSource().equals(this.getDown())) {
            index = this.getIndex();
            this.swapThisControlWith(index + 1);
            if (index < this.getParentItem().getControlList().size() - 1) {
                this.getParentItem().getControlList().get(index + 1).getDown().forceFocus();
            }
        }
        this.getParentItem().refreshWidget();
    }

    protected abstract void addButtonFunctionality();

    protected abstract boolean removeElementAt(int var1);

    public void setParentItem(MultiAttributeControl parentItem) {
        this.parentItem = parentItem;
    }

    public MultiAttributeControl getParentItem() {
        return this.parentItem;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setFieldComposite(Composite fieldComposite) {
        this.fieldComposite = fieldComposite;
    }

    public Composite getFieldComposite() {
        return this.fieldComposite;
    }

    public void setButton(ImageHyperlink button) {
        this.button = button;
    }

    public ImageHyperlink getButton() {
        return this.button;
    }

    public void setUp(ImageHyperlink up) {
        this.up = up;
    }

    public ImageHyperlink getUp() {
        return this.up;
    }

    public void setDown(ImageHyperlink down) {
        this.down = down;
    }

    public ImageHyperlink getDown() {
        return this.down;
    }
}

