/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views.log;

import java.util.function.Predicate;
import org.eclipse.elk.core.debug.model.ExecutionInfo;
import org.eclipse.elk.core.debug.views.AbstractLayoutDebugView;
import org.eclipse.elk.core.debug.views.log.LogLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class LayoutLogView
extends AbstractLayoutDebugView {
    public static final String VIEW_ID = "org.eclipse.elk.core.debug.logView";
    private Text logViewer;

    public LayoutLogView() {
        super(VIEW_ID, "elk.debug.logs");
    }

    @Override
    protected void treeSelectionChanged() {
        super.treeSelectionChanged();
        Object text = "";
        for (ExecutionInfo info : this.getSelectedExecutionInfos()) {
            if (info.getLogMessages().isEmpty()) continue;
            text = (String)text + String.join((CharSequence)"\n", info.getLogMessages()) + "\n\n";
        }
        this.logViewer.setText((String)text);
    }

    @Override
    protected Predicate<ExecutionInfo> getTreeFilter() {
        return info -> info.hasLogMessages() || info.hasDescendantsWithLogMessages();
    }

    @Override
    protected void customizeTreeViewer(TreeViewer treeViewer) {
        treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LogLabelProvider()));
    }

    @Override
    protected void setupRemainingControls(Composite parent) {
        this.logViewer = new Text(parent, 768);
        this.logViewer.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.logViewer.setEditable(false);
    }
}

