/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.egit.ui.internal.push.PushToGerritWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PushMode {
    UPSTREAM{

        @Override
        public Wizard getWizard(@NonNull Repository repository, RevCommit commit, boolean force) throws IOException {
            PushBranchWizard result = null;
            String fullBranch = repository.getFullBranch();
            if (fullBranch != null && fullBranch.startsWith("refs/heads/")) {
                Ref ref = repository.exactRef(fullBranch);
                result = new PushBranchWizard(repository, ref);
            } else if (commit != null) {
                result = new PushBranchWizard(repository, commit.getId());
            } else {
                ObjectId head = repository.resolve("HEAD");
                if (head != null) {
                    result = new PushBranchWizard(repository, head);
                }
            }
            if (result != null) {
                result.setForce(force);
            }
            return result;
        }
    }
    ,
    GERRIT{

        @Override
        public Wizard getWizard(@NonNull Repository repository, RevCommit commit, boolean force) throws IOException {
            Ref ref = repository.exactRef("HEAD");
            if (ref != null) {
                return new PushToGerritWizard(repository);
            }
            return null;
        }
    };


    public abstract Wizard getWizard(@NonNull Repository var1, RevCommit var2, boolean var3) throws IOException;
}

