/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.emfl.docgen.htm.reporter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.eclipse.emf.ecore.ENamedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternReporter
implements PatternExecutionReporter {
    private static final String HTML_FILE_EXTENSION = "html";
    private static final String PROJECT_NAME_CONTRACT = "projectName";
    private static final String OUTPUT_FOLDER_CONTRACT = "outputFolder";
    private static final String ELEMENT_PATTERN_PARAMETER = "element";

    public void executionFinished(String output, PatternContext context) {
    }

    public void loopFinished(String output, PatternContext context, Map<String, Object> parameterValues) {
        String projectName = (String)context.getValue(PROJECT_NAME_CONTRACT);
        String outputFolder = (String)context.getValue(OUTPUT_FOLDER_CONTRACT);
        ENamedElement anENamedElement = (ENamedElement)parameterValues.get(ELEMENT_PATTERN_PARAMETER);
        ByteArrayInputStream outputContent = new ByteArrayInputStream(output.getBytes());
        try {
            IFile file = this.getFile(anENamedElement, projectName, outputFolder);
            if (file.exists()) {
                file.setContents((InputStream)outputContent, true, false, null);
            } else {
                file.create((InputStream)outputContent, true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IFile getFile(ENamedElement anENamedElement, String projectName, String outputFolder) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        Path path = new Path("");
        String[] stringArray = outputFolder.split("\\.|/|\\\\");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String member = stringArray[n2];
            IFolder folder = project.getFolder((IPath)(path = path.append(member)));
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            ++n2;
        }
        path = path.append(String.valueOf(anENamedElement.getName()) + anENamedElement.eClass().getName());
        path = path.addFileExtension(HTML_FILE_EXTENSION);
        return project.getFile((IPath)path);
    }
}

