/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.contributors;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.ui.contributor.MenuContributor;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternViewpoint;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.engine.TranslationHelper;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.extension.PatternInitializer;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.contributors.EditHelper;
import org.eclipse.egf.pattern.ui.editors.templateEditor.TemplateExtensionRegistry;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class PatternMenuContributor
extends MenuContributor {
    public static final String EDIT_ACTION_ID = "edit-pattern";
    public static final String EDIT_TEMPLATE_ACTION_ID = "edit-template-pattern";
    private final EditPatternAction editAction = new EditPatternAction();
    private final EditTemplatePatternAction editTemplateAction = new EditTemplatePatternAction();
    private final GeneratePatternAction generateAction = new GeneratePatternAction();

    public void menuAboutToShow(IMenuManager menuManager) {
        IStructuredSelection selection2 = (IStructuredSelection)this.selection;
        if (selection2.size() == 1) {
            if (selection2.getFirstElement() instanceof PatternLibrary) {
                IContributionItem item = menuManager.find("create-child");
                MenuManager createChildMenuManager = null;
                if (item != null && item instanceof MenuManager) {
                    createChildMenuManager = (MenuManager)item;
                } else {
                    createChildMenuManager = new MenuManager(Messages.ViewpointContributor_newChildGroup_label);
                    menuManager.insertBefore("create-sibling", (IContributionItem)createChildMenuManager);
                }
                Map extensions = ExtensionHelper.getExtensions();
                for (String nature : extensions.keySet()) {
                    PatternExtension patternExtension = (PatternExtension)extensions.get(nature);
                    CommandParameter descriptor = new CommandParameter(null, (Object)PatternPackage.Literals.PATTERN_LIBRARY__ELEMENTS, (Object)patternExtension.getFactory().createPattern(null, "myPattern"));
                    CreatePatternAction createChildAction = new CreatePatternAction(this.activeEditorPart, this.selection, descriptor, (PatternLibrary)selection2.getFirstElement());
                    createChildAction.setText(Messages.bind((String)Messages.ViewpointContributor_newPattern_label, (Object)nature));
                    createChildAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)patternExtension.getImageURL()));
                    createChildMenuManager.add((IAction)createChildAction);
                }
            } else if (selection2.getFirstElement() instanceof Pattern) {
                menuManager.insertBefore("open", (IAction)this.editAction);
                menuManager.insertBefore("open", (IAction)this.editTemplateAction);
            } else if (selection2.getFirstElement() instanceof PatternViewpoint) {
                menuManager.insertBefore("open", (IAction)this.generateAction);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CreatePatternAction
    extends CreateChildAction {
        private final PatternLibrary library;

        public CreatePatternAction(IEditorPart editorPart, ISelection selection, Object descriptor, PatternLibrary library) {
            super(editorPart, selection, descriptor);
            this.library = library;
        }

        protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
            final Command createActionCommand = super.createActionCommand(editingDomain, collection);
            if (UnexecutableCommand.INSTANCE.equals(createActionCommand)) {
                return UnexecutableCommand.INSTANCE;
            }
            return createActionCommand.chain((Command)new AbstractCommand(){

                protected boolean prepare() {
                    return true;
                }

                public void execute() {
                    Collection affectedObjects = createActionCommand.getAffectedObjects();
                    Pattern pattern = (Pattern)affectedObjects.iterator().next();
                    for (PatternMethod m : pattern.getMethods()) {
                        m.setPatternFilePath(PatternHelper.Filename.computeFileURI((PatternMethod)m));
                    }
                    IProject project = EGFCorePlugin.getPlatformFcore((Resource)CreatePatternAction.this.library.eResource()).getPlatformBundle().getProject();
                    try {
                        PatternInitializer initializer = ExtensionHelper.getExtension((PatternNature)pattern.getNature()).createInitializer(project, pattern);
                        initializer.initContent();
                    }
                    catch (PatternException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (ExtensionHelper.MissingExtensionException e) {
                        Activator.getDefault().logError(e);
                    }
                }

                public void undo() {
                    Collection affectedObjects = createActionCommand.getAffectedObjects();
                    Pattern pattern = (Pattern)affectedObjects.iterator().next();
                    IProject project = EGFCorePlugin.getPlatformFcore((Resource)CreatePatternAction.this.library.eResource()).getPlatformBundle().getProject();
                    IFile currentFile = null;
                    try {
                        for (PatternMethod m : pattern.getMethods()) {
                            currentFile = project.getFile(m.getPatternFilePath().path());
                            currentFile.delete(true, false, null);
                        }
                        if (currentFile != null && currentFile.getParent() != null) {
                            currentFile.getParent().delete(true, null);
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError(e);
                    }
                }

                public void redo() {
                }
            });
        }
    }

    private final class EditPatternAction
    extends PatternAction {
        public EditPatternAction() {
            super(Messages.ViewpointContributor_openAction_label, PatternMenuContributor.EDIT_ACTION_ID);
        }

        public void run() {
            EditHelper.openPatternEditor(PatternMenuContributor.this.parent.getPage(), this.getPattern().getID());
        }
    }

    private final class EditTemplatePatternAction
    extends PatternAction {
        public EditTemplatePatternAction() {
            super(Messages.ViewpointContributor_openTemplateAction_label, PatternMenuContributor.EDIT_TEMPLATE_ACTION_ID);
        }

        public void run() {
            Pattern patternInTransactionalEditingDomain = this.getPatternInTransactionalEditingDomain();
            if (patternInTransactionalEditingDomain == null) {
                MessageDialog.openInformation((Shell)PatternMenuContributor.this.parent.getPage().getWorkbenchWindow().getShell(), (String)Messages.ViewpointContributor_missingPattern_title, (String)Messages.ViewpointContributor_missingPattern_message);
            } else {
                Pattern pattern = this.getPattern();
                String editor = TemplateExtensionRegistry.getEditor(pattern);
                if (editor != null) {
                    EditHelper.openTemplateEditor(PatternMenuContributor.this.parent.getPage(), pattern, editor);
                }
            }
        }
    }

    private final class GeneratePatternAction
    extends Action {
        public GeneratePatternAction() {
            super(Messages.ViewpointContributor_generatePatternAction_label);
            this.setId(this.getText());
        }

        public void run() {
            if (PatternMenuContributor.this.selection == null) {
                throw new IllegalStateException();
            }
            IStructuredSelection sselection = (IStructuredSelection)PatternMenuContributor.this.selection;
            if (sselection.isEmpty() || !(sselection.getFirstElement() instanceof EObject)) {
                throw new IllegalStateException();
            }
            Resource resource = ((EObject)sselection.getFirstElement()).eResource();
            HashSet patterns = new HashSet();
            PatternHelper patternCollector = PatternHelper.createCollector();
            try {
                try {
                    patterns.addAll(patternCollector.getPatterns(resource.getURI()));
                    new TranslationHelper().translate(patterns);
                }
                catch (PatternException e) {
                    Activator.getDefault().logError(e);
                    patterns.clear();
                    patternCollector.clear();
                }
            }
            finally {
                patterns.clear();
                patternCollector.clear();
            }
        }
    }

    private abstract class PatternAction
    extends Action {
        public PatternAction(String label, String id) {
            super(label);
            this.setId(id);
        }

        protected Pattern getPattern() {
            if (PatternMenuContributor.this.selection == null) {
                throw new IllegalStateException();
            }
            IStructuredSelection sselection = (IStructuredSelection)PatternMenuContributor.this.selection;
            if (sselection.size() != 1 || !(sselection.getFirstElement() instanceof Pattern)) {
                throw new IllegalStateException();
            }
            return (Pattern)sselection.getFirstElement();
        }

        protected Pattern getPatternInTransactionalEditingDomain() {
            Pattern pattern = this.getPattern();
            return PatternHelper.TRANSACTIONNAL_COLLECTOR.getPattern(pattern.getID());
        }
    }
}

