/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.execution;

import org.eclipse.egf.model.pattern.CallBackHandler;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;

public class CallHelper {
    public static void execute(String patternId, PatternContext ctx) throws ExtensionHelper.MissingExtensionException, PatternException {
        PatternHelper createCollector = PatternHelper.createCollector();
        Pattern pattern = createCollector.getPattern(patternId);
        PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
        String reason = extension.canExecute(pattern);
        if (reason != null) {
            throw new PatternException(reason);
        }
        extension.createEngine(pattern).execute(ctx);
    }

    public static void executeWithInjection(String patternId, PatternContext ctx, Object ... parameters) throws ExtensionHelper.MissingExtensionException, PatternException {
        PatternHelper createCollector = PatternHelper.createCollector();
        Pattern pattern = createCollector.getPattern(patternId);
        PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
        String reason = extension.canExecute(pattern);
        if (reason != null) {
            throw new PatternException(reason);
        }
        extension.createEngine(pattern).executeWithInjection(ctx, parameters);
    }

    public static void callBack(PatternContext ctx, Object model) throws ExtensionHelper.MissingExtensionException, PatternException {
        CallBackHandler handler = (CallBackHandler)ctx.getValue("pattern.call.back.handler");
        if (handler == null) {
            Activator.getDefault().logWarning(Messages.missing_callback_handler);
        }
        handler.handleCall(ctx, model);
    }

    public static void callSuper(PatternContext ctx, Object model) throws ExtensionHelper.MissingExtensionException, PatternException {
        CallBackHandler handler = (CallBackHandler)ctx.getValue("pattern.call.back.handler");
        if (handler == null) {
            Activator.getDefault().logWarning(Messages.missing_callback_handler);
        }
        handler.handleCall(ctx, model);
    }

    private CallHelper() {
    }
}

