/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributor;

import org.eclipse.egf.common.ui.helper.EditorHelper;
import org.eclipse.egf.core.ui.contributor.MenuContributor;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class ActivityMenuContributor
extends MenuContributor {
    public static final String EDIT_ACTION_ID = "edit-fcore";
    private final EditActivityAction _editAction = new EditActivityAction();

    public void menuAboutToShow(IMenuManager menuManager) {
        IStructuredSelection selection2 = (IStructuredSelection)this.selection;
        if (selection2.size() == 1 && (selection2.getFirstElement() instanceof Invocation || selection2.getFirstElement() instanceof InvocationContract)) {
            this._editAction.setEnabled(this._editAction.isEnabled());
            menuManager.insertBefore("open", (IAction)this._editAction);
        }
    }

    private class EditActivityAction
    extends Action {
        public EditActivityAction() {
            super(ModelEditorMessages.ActivityMenuContributor_openAction_label);
            this.setId(ActivityMenuContributor.EDIT_ACTION_ID);
        }

        public boolean isEnabled() {
            EObject eObject = this.getEObject();
            if (eObject == null) {
                return false;
            }
            if (eObject instanceof InternalEObject) {
                return !((InternalEObject)eObject).eIsProxy();
            }
            return false;
        }

        protected EObject getEObject() {
            if (ActivityMenuContributor.this.selection == null) {
                return null;
            }
            IStructuredSelection sselection = (IStructuredSelection)ActivityMenuContributor.this.selection;
            if (sselection.size() != 1) {
                return null;
            }
            Object object = sselection.getFirstElement();
            if (object instanceof Invocation) {
                Invocation invocation = (Invocation)object;
                return invocation.getInvokedActivity();
            }
            if (object instanceof InvocationContract) {
                InvocationContract invocationContract = (InvocationContract)object;
                return invocationContract.getInvokedContract();
            }
            return null;
        }

        public void run() {
            try {
                IEditorPart part;
                EObject eObject = this.getEObject();
                if (eObject == null) {
                    return;
                }
                URI uri = EcoreUtil.getURI((EObject)eObject);
                if (uri != null && (part = EditorHelper.openEditor((URI)uri)) != null && part instanceof IEditingDomainProvider) {
                    EditorHelper.setSelectionToViewer((IEditorPart)part, (URI)uri);
                }
            }
            catch (PartInitException pie) {
                EGFModelEditorPlugin.getPlugin().logError(pie);
            }
        }
    }
}

