/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.extension;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.emf.common.util.URI;

public abstract class PatternInitializer {
    private final IProject project;
    private final Pattern pattern;

    public PatternInitializer(IProject project, Pattern pattern) {
        this.project = project;
        this.pattern = pattern;
    }

    public void initContent() throws PatternException {
        for (PatternMethod method : this.pattern.getMethods()) {
            IFile outputFile = this.getFile(method);
            String content = null;
            content = method == this.pattern.getHeaderMethod() ? this.getHeaderContent(method) : (method == this.pattern.getFooterMethod() ? this.getFooterContent(method) : (method == this.pattern.getInitMethod() ? this.getInitContent(method) : this.getDefaultContent(method)));
            try {
                FileHelper.setContent(outputFile, content == null ? "" : content);
            }
            catch (CoreException e) {
                throw new PatternException((Throwable)e);
            }
        }
    }

    protected abstract String getHeaderContent(PatternMethod var1) throws PatternException;

    protected abstract String getFooterContent(PatternMethod var1) throws PatternException;

    protected abstract String getInitContent(PatternMethod var1) throws PatternException;

    protected abstract String getDefaultContent(PatternMethod var1) throws PatternException;

    protected IFile getFile(PatternMethod method) {
        URI patternFilePath = method.getPatternFilePath();
        if (patternFilePath == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.initializer_error1, (Object)method.getName()));
        }
        IFile file = this.project.getFile(patternFilePath.toFileString());
        if (file == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.initializer_error2, (Object)method.getName()));
        }
        return file;
    }
}

