/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;

public class ExtensionHelper {
    public static IPluginExtension createExtension(IPluginModelBase pluginModelBase_p, String extensionPointId_p) {
        IPluginExtension extension = null;
        IPluginModelFactory pluginModelFactory = pluginModelBase_p.getPluginFactory();
        if (pluginModelFactory != null) {
            extension = pluginModelFactory.createExtension();
            try {
                extension.setPoint(extensionPointId_p);
                pluginModelBase_p.getExtensions().add(extension);
            }
            catch (CoreException ce) {
                EGFPDEPlugin.getDefault().logError(new String("ExtensionHelper.createExtension(..) _"), ce);
                extension = null;
            }
        }
        return extension;
    }

    public static IPluginElement createPluginElement(IPluginParent parent_p, String name_p) {
        if (parent_p == null) {
            return null;
        }
        IPluginElement element = null;
        IExtensionsModelFactory factory = parent_p.getModel().getFactory();
        if (factory != null) {
            element = factory.createElement((IPluginObject)parent_p);
            try {
                element.setName(name_p);
                parent_p.add((IPluginObject)element);
            }
            catch (CoreException ce) {
                EGFPDEPlugin.getDefault().logError(new String("ExtensionHelper.createPluginElement(..) _"), ce);
                element = null;
            }
        }
        return element;
    }

    public static IPluginExtension[] getPluginExtension(IExtensions extensionPart_p, String fullyQualifiedExtensionPointId_p) {
        ArrayList<IPluginExtension> result = new ArrayList<IPluginExtension>(0);
        if (fullyQualifiedExtensionPointId_p == null || extensionPart_p == null) {
            return result.toArray(new IPluginExtension[0]);
        }
        IPluginExtension[] extensions = extensionPart_p.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IPluginExtension currentExtension = extensions[i];
            if (fullyQualifiedExtensionPointId_p.equals(currentExtension.getPoint())) {
                result.add(currentExtension);
            }
            ++i;
        }
        return result.toArray(new IPluginExtension[result.size()]);
    }

    public static boolean removePluginExtension(IExtensions extensionPart_p, String extensionPointId_p, String elementId_p, Object elementIdValue_p) {
        IPluginExtension[] matchingExtensions;
        boolean result = false;
        IPluginExtension[] iPluginExtensionArray = matchingExtensions = ExtensionHelper.getPluginExtension(extensionPart_p, extensionPointId_p);
        int n = matchingExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension currentExtension = iPluginExtensionArray[n2];
            result = ExtensionHelper.removePluginElement((IPluginParent)currentExtension, elementId_p, elementIdValue_p);
            if (result) {
                int childCount = currentExtension.getChildCount();
                try {
                    if (childCount != 0) break;
                    extensionPart_p.remove(currentExtension);
                }
                catch (CoreException ce) {
                    EGFPDEPlugin.getDefault().logError(new String("ExtensionHelper.removePluginExtension(..) _"), ce);
                }
                break;
            }
            ++n2;
        }
        return result;
    }

    public static IPluginElement getPluginElement(IPluginParent parent_p, String attributeId_p, Object elementIdValue_p) {
        IPluginElement result = null;
        if (elementIdValue_p == null || parent_p == null) {
            return result;
        }
        IPluginObject[] children = parent_p.getChildren();
        int i = 0;
        while (i < children.length && result == null) {
            IPluginObject object = children[i];
            if (object instanceof IPluginElement) {
                IPluginElement child = (IPluginElement)object;
                String elementIdValue = null;
                if (attributeId_p == null) {
                    elementIdValue = child.getName();
                } else {
                    IPluginAttribute attribute = child.getAttribute(attributeId_p);
                    if (attribute != null) {
                        elementIdValue = attribute.getValue();
                    }
                }
                if (elementIdValue != null) {
                    if (elementIdValue_p instanceof URI) {
                        if (elementIdValue_p.equals(URIHelper.getPlatformURI((IPluginModelBase)parent_p.getPluginModel(), (String)elementIdValue))) {
                            result = child;
                        }
                    } else if (elementIdValue_p.equals(elementIdValue)) {
                        result = child;
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static IPluginElement[] getPluginElement(IPluginParent parent_p, String nodeName_p) {
        ArrayList<IPluginElement> result = new ArrayList<IPluginElement>(0);
        if (nodeName_p == null || parent_p == null) {
            return result.toArray(new IPluginElement[0]);
        }
        IPluginObject[] children = parent_p.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginElement element;
            IPluginObject object = children[i];
            if (object instanceof IPluginElement && nodeName_p.equals((element = (IPluginElement)object).getName())) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new IPluginElement[result.size()]);
    }

    public static boolean removePluginElement(IPluginParent parent_p, String elementId_p, Object elementIdValue_p) {
        boolean result = false;
        if (elementIdValue_p == null || parent_p == null) {
            return result;
        }
        IPluginElement pluginElement = ExtensionHelper.getPluginElement(parent_p, elementId_p, elementIdValue_p);
        try {
            if (pluginElement != null) {
                parent_p.remove((IPluginObject)pluginElement);
                result = true;
            }
        }
        catch (CoreException ce) {
            EGFPDEPlugin.getDefault().logError(new String("ExtensionHelper.removePluginElement(..) _"), ce);
        }
        return result;
    }
}

