/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.ui.activator.EGFAbstractUIPlugin;
import org.eclipse.egf.core.fcore.IResourceFcoreListener;
import org.eclipse.egf.core.pde.extension.IFcoreExtensionFactory;
import org.eclipse.egf.core.pde.internal.FcoreGeneratorHelper;
import org.eclipse.egf.core.pde.internal.extension.FcoreExtensionFactory;
import org.eclipse.egf.core.pde.internal.plugin.PluginChangesCommandRunner;
import org.eclipse.egf.core.pde.internal.resource.FcoreResourceListener;
import org.eclipse.egf.core.pde.l10n.EGFPDEMessages;
import org.eclipse.egf.core.pde.plugin.IPluginChangesCommandRunner;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.BundleContext;

public class EGFPDEPlugin
extends EGFAbstractUIPlugin
implements ISaveParticipant {
    public static final String PLUGIN_FILE_NAME = "plugin.xml";
    public static final String FRAGMENT_FILE_NAME = "fragment.xml";
    public static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";
    private static EGFPDEPlugin __plugin;
    private IPluginChangesCommandRunner _pluginChangesCommandRunner;
    private FcoreResourceListener _fcoreResourceListener;

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return EGFPDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = EGFPDEPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = EGFPDEPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public void start(BundleContext context_p) throws Exception {
        super.start(context_p);
        __plugin = this;
        this._fcoreResourceListener = new FcoreResourceListener();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Job processSavedState = new Job(EGFPDEMessages.savedState_jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    workspace.run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor progress) throws CoreException {
                            ISavedState savedState = workspace.addSaveParticipant((Plugin)EGFPDEPlugin.getDefault(), (ISaveParticipant)EGFPDEPlugin.this);
                            if (savedState != null) {
                                ((EGFPDEPlugin)(this).EGFPDEPlugin.this)._fcoreResourceListener._overridenEventType = 1;
                                savedState.processResourceChangeEvents((IResourceChangeListener)EGFPDEPlugin.this._fcoreResourceListener);
                            }
                        }
                    }, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        processSavedState.setSystem(true);
        processSavedState.setPriority(20);
        processSavedState.schedule();
    }

    public void doneSaving(ISaveContext saveContext) {
    }

    public void prepareToSave(ISaveContext saveContext) throws CoreException {
    }

    public void rollback(ISaveContext saveContext) {
    }

    public void saving(ISaveContext saveContext) throws CoreException {
        saveContext.needDelta();
    }

    public void stop(BundleContext context_p) throws Exception {
        this._fcoreResourceListener.dispose();
        this._fcoreResourceListener = null;
        __plugin = null;
        super.stop(context_p);
    }

    public static EGFPDEPlugin getDefault() {
        return __plugin;
    }

    public static IFcoreExtensionFactory getFcoreExtensionHelper() {
        return FcoreExtensionFactory.getInstance();
    }

    public void addResourceFcoreListener(IResourceFcoreListener listener) {
        this._fcoreResourceListener.addResourceFcoreListener(listener);
    }

    public void removeResourceFcoreListener(IResourceFcoreListener listener) {
        this._fcoreResourceListener.removeResourceFcoreListener(listener);
    }

    public IFile getFile(IPluginModelBase pluginModelBase_p) {
        return this.getFile(ProjectHelper.getProject((IPluginModelBase)pluginModelBase_p));
    }

    public IFile getFile(IProject project_p) {
        IFile result = null;
        if (project_p == null) {
            return result;
        }
        result = project_p.getFile(PLUGIN_FILE_NAME);
        result = result.exists() ? result : null;
        return result;
    }

    public boolean isPluginFile(IResource resource_p) {
        if (resource_p != null && resource_p instanceof IFile) {
            return ((IFile)resource_p).getName().equals(PLUGIN_FILE_NAME);
        }
        return false;
    }

    public static IPluginChangesCommandRunner getPluginChangesCommandRunner() {
        if (EGFPDEPlugin.getDefault()._pluginChangesCommandRunner == null) {
            EGFPDEPlugin.getDefault()._pluginChangesCommandRunner = new PluginChangesCommandRunner();
        }
        return EGFPDEPlugin.getDefault()._pluginChangesCommandRunner;
    }

    public void addEntryInBinaryBuild(IProject project_p, String entryName_p) {
        if (project_p == null || entryName_p == null) {
            return;
        }
        WorkspaceBuildModel buildModel = FcoreGeneratorHelper.getBuildModel(project_p);
        if (buildModel != null) {
            FcoreGeneratorHelper.addEntryInBinaryBuild((IBuildModel)buildModel, entryName_p);
            buildModel.save();
        }
    }
}

