/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fprod.producer.internal.manager;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.fprod.producer.context.ITaskInvocationProductionContext;
import org.eclipse.egf.fprod.producer.internal.context.FprodProducerContextFactory;
import org.eclipse.egf.fprod.producer.internal.context.TaskInvocationProductionContext;
import org.eclipse.egf.fprod.producer.internal.manager.ProductionPlanInvocationManager;
import org.eclipse.egf.fprod.producer.internal.manager.TaskManager;
import org.eclipse.egf.fprod.producer.manager.IProductionPlanManager;
import org.eclipse.egf.fprod.producer.manager.ITaskInvocationManager;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fprod.ProductionPlanInvocation;
import org.eclipse.egf.model.fprod.Task;
import org.eclipse.egf.model.fprod.TaskInvocation;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.UniqueEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInvocationManager
extends ProductionPlanInvocationManager
implements ITaskInvocationManager {
    private TaskManager _taskManager;

    public TaskInvocationManager(IProductionPlanManager parent, TaskInvocation taskInvocation) throws InvocationException {
        super(parent, (ProductionPlanInvocation<?>)taskInvocation);
    }

    @Override
    public TaskInvocation getElement() {
        return (TaskInvocation)super.getElement();
    }

    @Override
    public ITaskInvocationProductionContext getProductionContext() throws InvocationException {
        return this.getInternalProductionContext();
    }

    @Override
    public TaskInvocationProductionContext getInternalProductionContext() throws InvocationException {
        if (this._productionContext == null) {
            this._productionContext = FprodProducerContextFactory.createContext(this.getParent().getProductionContext(), this.getElement(), this.getProjectBundleSession());
        }
        return (TaskInvocationProductionContext)this._productionContext;
    }

    public TaskManager getTaskManager() throws InvocationException {
        if (this._taskManager == null && this.getElement().getActivity() != null) {
            this._taskManager = new TaskManager(this, (Task)this.getElement().getActivity());
        }
        return this._taskManager;
    }

    public void dispose() throws InvocationException {
        super.dispose();
        if (this.getTaskManager() != null) {
            this.getTaskManager().dispose();
        }
    }

    public Diagnostic canInvoke() throws InvocationException {
        BasicDiagnostic diagnostic = this.canInvokeElement();
        if (this.getTaskManager() != null) {
            diagnostic.add(this.getTaskManager().canInvoke());
        }
        return diagnostic;
    }

    public void initializeContext() throws InvocationException {
        super.initializeContext();
        if (this.getTaskManager() != null) {
            this.getTaskManager().initializeContext();
        }
    }

    public int getSteps() throws InvocationException {
        if (this.getTaskManager() != null) {
            return this.getTaskManager().getSteps();
        }
        return 0;
    }

    public List<Activity> getActivities() throws InvocationException {
        UniqueEList activities = new UniqueEList();
        if (this.getTaskManager() != null) {
            activities.addAll(this.getTaskManager().getActivities());
        }
        return activities;
    }

    public Diagnostic invoke(IProgressMonitor monitor) throws InvocationException {
        TaskManager taskManager;
        BasicDiagnostic diagnostic = this.canInvokeElement();
        if (diagnostic.getSeverity() != 4 && (taskManager = this.getTaskManager()) != null) {
            diagnostic.add(taskManager.invoke(monitor));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        return diagnostic;
    }
}

