/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fprod.producer.internal.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.fprod.producer.context.IProductionPlanProductionContext;
import org.eclipse.egf.fprod.producer.internal.context.FprodProducerContextFactory;
import org.eclipse.egf.fprod.producer.internal.context.ProductionPlanProductionContext;
import org.eclipse.egf.fprod.producer.internal.manager.FactoryComponentInvocationManager;
import org.eclipse.egf.fprod.producer.internal.manager.TaskInvocationManager;
import org.eclipse.egf.fprod.producer.manager.IProductionPlanInvocationManager;
import org.eclipse.egf.fprod.producer.manager.IProductionPlanManager;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fprod.FactoryComponentInvocation;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.egf.model.fprod.TaskInvocation;
import org.eclipse.egf.producer.internal.manager.OrchestrationManager;
import org.eclipse.egf.producer.manager.IFactoryComponentManager;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionPlanManager
extends OrchestrationManager
implements IProductionPlanManager {
    private Map<Invocation<?>, IProductionPlanInvocationManager> _managers;

    public ProductionPlanManager(IFactoryComponentManager parent, ProductionPlan productionPlan) throws InvocationException {
        super(parent, (Orchestration)productionPlan);
    }

    @Override
    public ProductionPlan getElement() {
        return (ProductionPlan)super.getElement();
    }

    @Override
    public IProductionPlanProductionContext getProductionContext() throws InvocationException {
        return this.getInternalProductionContext();
    }

    public ProductionPlanProductionContext getInternalProductionContext() throws InvocationException {
        if (this._productionContext == null) {
            this._productionContext = FprodProducerContextFactory.createContext(this.getParent().getProductionContext(), this.getElement(), this.getProjectBundleSession());
        }
        return (ProductionPlanProductionContext)this._productionContext;
    }

    private Map<Invocation<?>, IProductionPlanInvocationManager> getProductionPlanManagers() throws InvocationException {
        if (this._managers == null && this.getElement().getInvocations() != null) {
            this._managers = new HashMap(this.getElement().getInvocations().size());
            for (Invocation invocation : this.getElement().getInvocations()) {
                if (invocation instanceof FactoryComponentInvocation) {
                    this._managers.put(invocation, new FactoryComponentInvocationManager((IProductionPlanManager)this, (FactoryComponentInvocation)invocation));
                    continue;
                }
                if (!(invocation instanceof TaskInvocation)) continue;
                this._managers.put(invocation, new TaskInvocationManager((IProductionPlanManager)this, (TaskInvocation)invocation));
            }
        }
        return this._managers;
    }

    public void dispose() throws InvocationException {
        super.dispose();
        Map<Invocation<?>, IProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : this.getElement().getInvocations()) {
                managers.get(invocation).dispose();
            }
        }
    }

    public Diagnostic canInvoke() throws InvocationException {
        BasicDiagnostic diagnostic = this.canInvokeElement();
        Map<Invocation<?>, IProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : this.getElement().getInvocations()) {
                diagnostic.add(managers.get(invocation).canInvoke());
            }
        }
        return diagnostic;
    }

    public void initializeContext() throws InvocationException {
        super.initializeContext();
        Map<Invocation<?>, IProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : this.getElement().getInvocations()) {
                managers.get(invocation).initializeContext();
            }
        }
    }

    public int getSteps() throws InvocationException {
        int steps = 0;
        Map<Invocation<?>, IProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : this.getElement().getInvocations()) {
                steps += managers.get(invocation).getSteps();
            }
        }
        return steps;
    }

    public List<Activity> getActivities() throws InvocationException {
        UniqueEList activities = new UniqueEList();
        Map<Invocation<?>, IProductionPlanInvocationManager> managers = this.getProductionPlanManagers();
        if (managers != null) {
            for (Invocation invocation : this.getElement().getInvocations()) {
                activities.addAll(managers.get(invocation).getActivities());
            }
        }
        return activities;
    }

    public Diagnostic invoke(IProgressMonitor monitor) throws InvocationException {
        Map<Invocation<?>, IProductionPlanInvocationManager> managers;
        BasicDiagnostic diagnostic = this.canInvokeElement();
        if (diagnostic.getSeverity() != 4 && (managers = this.getProductionPlanManagers()) != null) {
            int steps = this.getSteps();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)this.getName()), (int)(steps * 900));
            try {
                for (Invocation invocation : this.getElement().getInvocations()) {
                    IProductionPlanInvocationManager manager = managers.get(invocation);
                    Diagnostic innerDiagnostic = manager.invoke((IProgressMonitor)subMonitor.newChild(900 * manager.getSteps(), 0));
                    diagnostic.add(innerDiagnostic);
                    if (innerDiagnostic.getSeverity() == 4) {
                        break;
                    }
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
            finally {
                subMonitor.done();
            }
        }
        return diagnostic;
    }
}

