/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHelper {
    private JavaHelper() {
    }

    private static IFolder findFolder(IPath path) {
        if (path == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource == null || !(resource instanceof IFolder)) {
            return null;
        }
        return (IFolder)resource;
    }

    public static ClassLoader getProjectClassLoader(IJavaProject project) throws CoreException {
        return new URLClassLoader(JavaHelper.getURLOutputFolders(project), ProjectHelper.class.getClassLoader());
    }

    public static List<IFolder> getOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (project == null || !project.exists()) {
            return folders;
        }
        IFolder folder = JavaHelper.findFolder(project.getOutputLocation());
        if (folder != null) {
            folders.add(folder);
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = JavaHelper.findFolder(entry.getOutputLocation())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    public static List<String> getStringOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (!project.exists()) {
            return folders;
        }
        List<IFolder> innerFolders = JavaHelper.getOutputFolders(project);
        for (IFolder folder : innerFolders) {
            folders.add(folder.getFullPath().removeFirstSegments(1).toString());
        }
        folders.add(project.getOutputLocation().removeFirstSegments(1).toString());
        return folders;
    }

    private static URL[] getURLOutputFolders(IJavaProject project) throws CoreException {
        List<String> outputFolders = JavaHelper.getStringOutputFolders(project);
        UniqueEList urls = new UniqueEList(outputFolders.size());
        for (String outputFolder : outputFolders) {
            try {
                urls.add(new URL("file", null, outputFolder));
            }
            catch (MalformedURLException mue) {
                throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCommonMessages.JavaHelper_AnalysingFailure, (Object)project.getProject().getName()), mue));
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static boolean deleteClass(IJavaProject project, IPath path, boolean deleteParent) throws CoreException {
        if (project == null || path == null) {
            return false;
        }
        IFolder sourceFolder = JavaHelper.getSourceFolder(project, path);
        if (sourceFolder == null) {
            return false;
        }
        IResource resource = sourceFolder.findMember(path);
        if (resource == null || !(resource instanceof IFile)) {
            return false;
        }
        if (!FileHelper.deleteResource(resource)) {
            return false;
        }
        if (deleteParent) {
            IContainer container = (IContainer)sourceFolder.findMember(path.removeLastSegments(1));
            while (!container.equals((Object)sourceFolder)) {
                try {
                    IResource[] members = container.members();
                    if (members != null && members.length != 0 || !FileHelper.deleteResource((IResource)container)) break;
                    container = container.getParent();
                }
                catch (CoreException coreException) {
                    break;
                }
            }
        }
        return true;
    }

    public static IFile getSourceFile(IJavaProject project, IPath path) throws CoreException {
        if (project == null || path == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            IResource resource = folder.findMember(path);
            if (resource == null || !(resource instanceof IFile)) continue;
            return (IFile)resource;
        }
        return null;
    }

    public static IFolder getSourceFolder(IJavaProject project, IPath path) throws CoreException {
        if (project == null || path == null) {
            return null;
        }
        List<IFolder> folders = JavaHelper.getSourceFolders(project);
        for (IFolder folder : folders) {
            IResource resource = folder.findMember(path);
            if (resource == null) continue;
            return folder;
        }
        return null;
    }

    public static List<IFolder> getSourceFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        if (project == null || !project.exists()) {
            return folders;
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = JavaHelper.findFolder(entry.getPath())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    public static List<IFolder> getSourceAndOutputFolders(IJavaProject project) throws CoreException {
        UniqueEList folders = new UniqueEList();
        folders.addAll(JavaHelper.getSourceFolders(project));
        folders.addAll(JavaHelper.getOutputFolders(project));
        return folders;
    }
}

