/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.internal.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.MathHelper;
import org.eclipse.egf.console.EGFConsolePlugin;
import org.eclipse.egf.pattern.PatternActivator;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.internal.PatternRegistry;
import org.eclipse.egf.pattern.production.PatternProducer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBuilder
extends IncrementalProjectBuilder {
    private static boolean DEBUG = PatternActivator.getDefault().isDebugging();
    private static IProject[] EMPTY_LIST = new IProject[0];
    private PatternVisitor _patternVisitor = new PatternVisitor();
    private IJavaProject _javaProject;
    private Map<String, IDescriptor> _patterns;

    protected IProject[] build(int kind_p, Map args_p, IProgressMonitor monitor_p) throws CoreException {
        if (!this.initialize(monitor_p)) {
            return EMPTY_LIST;
        }
        try {
            IResourceDelta delta = this.getDelta(this._javaProject.getProject());
            if (kind_p != 6 || delta != null) {
                if (delta.getKind() != 0) {
                    this._patternVisitor.reset();
                    delta.accept((IResourceDeltaVisitor)this._patternVisitor);
                    this.rebuildFactoryComponent(this._patternVisitor.getRebuildFactoryComponent());
                    this.rebuildPatternModel(this._patternVisitor.getRebuildPatternModel());
                    this.produce(this._patternVisitor.getProduce(), monitor_p);
                }
            } else {
                this.produce(this.getPatterns().values(), monitor_p);
            }
        }
        finally {
            this.cleanup();
        }
        return EMPTY_LIST;
    }

    protected void produce(Collection<IDescriptor> descriptors_p, IProgressMonitor monitor_p) {
        long start;
        if (descriptors_p == null) {
            return;
        }
        int rank = 1;
        long stepStart = start = System.currentTimeMillis();
        for (IDescriptor descriptor : descriptors_p) {
            String definition = (String)descriptor.getValue("model");
            if (definition == null || definition.trim().length() == 0) continue;
            PatternHandler patternHandler = new PatternHandler(true);
            try {
                try {
                    PatternHandler.PatternData patternData = patternHandler.load(definition);
                    if (patternData != null) {
                        PatternProducer.producePatterns(patternData.getPattern().getId(), monitor_p);
                        long stepStop = System.currentTimeMillis();
                        if (DEBUG) {
                            EGFConsolePlugin.getConsole().logInfo(NLS.bind((String)"Produce Pattern Model ''{0}'', step {1}/{2}", (Object[])new Object[]{definition, rank++, descriptors_p.size()}));
                            EGFConsolePlugin.getConsole().logWarning(NLS.bind((String)"Total elapsed {0}, Step elapsed {1}", (Object)MathHelper.formatAsDuration((long)(stepStop - start)), (Object)MathHelper.formatAsDuration((long)(stepStop - stepStart))), 1);
                            stepStart = System.currentTimeMillis();
                        }
                    }
                }
                catch (Throwable t) {
                    if (DEBUG) {
                        EGFConsolePlugin.getConsole().logThrowable(NLS.bind((String)"Unable to load Pattern Model ''{0}''", (Object)definition), t);
                    }
                    PatternActivator.getDefault().log(t);
                    if (!monitor_p.isCanceled()) continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (monitor_p.isCanceled()) break;
                throw throwable;
            }
            if (monitor_p.isCanceled()) break;
        }
    }

    protected void rebuildFactoryComponent(Collection<IDescriptor> descriptors_p) {
        if (descriptors_p == null) {
            return;
        }
        for (IDescriptor descriptor : descriptors_p) {
            String definition = (String)descriptor.getValue("model");
            if (definition == null || definition.trim().length() == 0) continue;
            PatternHandler patternHandler = new PatternHandler(true);
            try {
                PatternHandler.PatternData patternData = patternHandler.load(definition);
                if (patternData == null || !DEBUG) continue;
                EGFConsolePlugin.getConsole().logWarning(NLS.bind((String)"Factory Component Should be updated ''{0}''", (Object)patternData.getFactoryComponentId()));
            }
            catch (Throwable t) {
                if (DEBUG) {
                    EGFConsolePlugin.getConsole().logThrowable(NLS.bind((String)"Unable to load Pattern Model ''{0}''", (Object)definition), t);
                }
                PatternActivator.getDefault().log(t);
            }
        }
    }

    protected void rebuildPatternModel(Collection<IDescriptor> descriptors_p) {
        if (descriptors_p == null) {
            return;
        }
        for (IDescriptor descriptor : descriptors_p) {
            String definition = (String)descriptor.getValue("model");
            if (definition == null || definition.trim().length() == 0) continue;
            PatternHandler patternHandler = new PatternHandler(true);
            try {
                PatternHandler.PatternData patternData = patternHandler.load(definition);
                if (patternData == null || !DEBUG) continue;
                EGFConsolePlugin.getConsole().logWarning(NLS.bind((String)"Pattern Model Should be updated ''{0}''", (Object)definition));
            }
            catch (Throwable t) {
                if (DEBUG) {
                    EGFConsolePlugin.getConsole().logThrowable(NLS.bind((String)"Unable to load Pattern Model ''{0}''", (Object)definition), t);
                }
                PatternActivator.getDefault().log(t);
            }
        }
    }

    private void cleanup() {
        this._patterns = null;
    }

    protected void clean(IProgressMonitor monitor_p) throws CoreException {
    }

    private boolean initialize(IProgressMonitor monitor_p) throws CoreException {
        if (PatternActivator.getDefault().getBundle().getState() != 32 || monitor_p.isCanceled()) {
            return false;
        }
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return false;
        }
        this._javaProject = JavaCore.create((IProject)project);
        return true;
    }

    protected Map<String, IDescriptor> getPatterns() {
        if (this._patterns == null) {
            this._patterns = PatternRegistry.getPatterns(this._javaProject.getProject());
        }
        return this._patterns;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PatternVisitor
    implements IResourceDeltaVisitor {
        private Collection<IDescriptor> _rebuildPatternModel = new ArrayList<IDescriptor>();
        private Collection<IDescriptor> _rebuildFactoryComponent = new ArrayList<IDescriptor>();
        private Collection<IDescriptor> _produce = new ArrayList<IDescriptor>();

        PatternVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null) {
                return false;
            }
            int kind = delta.getKind();
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if ("pm".equals(resource.getFileExtension())) {
                    IDescriptor descriptor = PatternBuilder.this.getPatterns().get(resource.getFullPath().removeFileExtension().lastSegment());
                    if (descriptor == null) {
                        return false;
                    }
                    String model = (String)descriptor.getValue("model");
                    if (model == null || model.trim().length() == 0) {
                        return false;
                    }
                    IResource modelResource = FileHelper.getPlatformResource((IPath)new Path(model));
                    if (modelResource == null || !modelResource.equals((Object)resource)) {
                        return false;
                    }
                    if (kind == 2) {
                        this._rebuildFactoryComponent.add(descriptor);
                    }
                    if (kind == 1 || kind == 4) {
                        this._produce.add(descriptor);
                    }
                } else if ("pt".equals(resource.getFileExtension())) {
                    IDescriptor descriptor = PatternBuilder.this.getPatterns().get(resource.getParent().getFullPath().lastSegment());
                    if (descriptor == null) {
                        return false;
                    }
                    if (kind == 2) {
                        this._rebuildPatternModel.add(descriptor);
                    }
                    if (kind == 4) {
                        this._produce.add(descriptor);
                    }
                }
                return false;
            }
            return true;
        }

        public void reset() {
            this._produce.clear();
            this._rebuildPatternModel.clear();
            this._rebuildFactoryComponent.clear();
        }

        public Collection<IDescriptor> getProduce() {
            return this._produce;
        }

        public Collection<IDescriptor> getRebuildFactoryComponent() {
            return this._rebuildFactoryComponent;
        }

        public Collection<IDescriptor> getRebuildPatternModel() {
            return this._rebuildPatternModel;
        }
    }
}

