/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.execution;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.context.ProductionContext;
import org.eclipse.egf.pattern.execution.IPatternExecutionReporter;
import org.eclipse.egf.pattern.production.TemplateType;
import org.eclipse.egf.pattern.production.jet.IGenerator;
import org.eclipse.emf.ecore.resource.Resource;

public class PatternExecutionHelper {
    private static final Logger __logger = Logger.getLogger((String)PatternExecutionHelper.class.getPackage().getName());

    private static Object getValue(Object argument_p, ArgumentKey key_p) {
        Object result = null;
        if (argument_p instanceof Map) {
            Map arguments = (Map)argument_p;
            result = arguments.get((Object)key_p);
        }
        return result;
    }

    public static Resource getResource(Object argument_p) {
        return (Resource)PatternExecutionHelper.getValue(argument_p, ArgumentKey.EMF_RESOURCE);
    }

    public static ProductionContext getContext(Object argument_p) {
        return (ProductionContext)PatternExecutionHelper.getValue(argument_p, ArgumentKey.PRODUCTION_CONTEXT);
    }

    public static IPatternExecutionReporter getExecutionReporter(Object argument_p) {
        return (IPatternExecutionReporter)PatternExecutionHelper.getValue(argument_p, ArgumentKey.EXECUTION_REPORTER);
    }

    public static Object invokePattern(String patternFullId_p, Object arguments_p) {
        Object result = "";
        try {
            result = PatternExecutionHelper.doRunPattern(patternFullId_p, arguments_p);
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("PatternElementRunnerTask.invokePattern(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }

    public static Object doRunPattern(String patternFullId_p, Object arguments_p) throws Exception {
        String result = "";
        IConfigurationElement patternConfigElement = ExtensionPointHelper.getConfigurationElement((String)"org.eclipse.egf.pattern", (String)"patternTemplate", (String)patternFullId_p);
        if (patternConfigElement != null) {
            String templateEngineType = patternConfigElement.getAttribute("type");
            if (TemplateType.JET.getId().equals(templateEngineType)) {
                IGenerator templateCode = (IGenerator)patternConfigElement.createExecutableExtension("class");
                result = templateCode.generate(arguments_p);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgumentKey {
        EMF_RESOURCE,
        PRODUCTION_CONTEXT,
        EXECUTION_REPORTER;

    }
}

