/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ecore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pde.pattern.reader.IPatternExtensionReader;
import org.eclipse.egf.pde.pattern.reader.PlatformPatternExtensionReader;
import org.eclipse.egf.pde.pattern.reader.WorkspacePatternExtensionReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSeeker {
    private static final Logger __logger = Logger.getLogger((String)PatternSeeker.class.getPackage().getName());
    private List<IPatternExtensionReader> _readers = new ArrayList<IPatternExtensionReader>(1);

    public PatternSeeker(boolean searchInWorkspace_p) {
        if (searchInWorkspace_p) {
            this._readers.add((IPatternExtensionReader)new WorkspacePatternExtensionReader());
        }
        this._readers.add((IPatternExtensionReader)new PlatformPatternExtensionReader());
    }

    public List<PatternHandler.PatternData> getPatternsData(String fullId_p) {
        ArrayList<PatternHandler.PatternData> result = new ArrayList<PatternHandler.PatternData>(0);
        this.getPatternsData(fullId_p, fullId_p, null, result);
        return result;
    }

    protected IDescriptor getRootLibraryFromId(String libraryId_p) {
        IDescriptor result = null;
        Iterator<IPatternExtensionReader> readers = this._readers.iterator();
        while (readers.hasNext() && result == null) {
            result = readers.next().getPatternLibrary(libraryId_p);
        }
        return result;
    }

    protected List<IDescriptor> getChildrenLibraries(IDescriptor parentLibrary_p) {
        List children = parentLibrary_p.getChildren();
        ArrayList<IDescriptor> result = new ArrayList<IDescriptor>(children.size());
        for (IDescriptor descriptor : children) {
            if (!"library".equals(descriptor.getValue("patternExtType"))) continue;
            result.add(descriptor);
        }
        return result;
    }

    protected void getPatternsData(String fullId_p, String partialId_p, IDescriptor library_p, List<PatternHandler.PatternData> data_p) {
        if (partialId_p == null) {
            return;
        }
        int separatorPosition = partialId_p.indexOf(47);
        if (separatorPosition > 0) {
            String libraryId = partialId_p.substring(0, separatorPosition);
            IDescriptor library = null;
            if (library_p == null) {
                library = this.getRootLibraryFromId(libraryId);
            } else {
                List<IDescriptor> libraries = this.getChildrenLibraries(library_p);
                Iterator<IDescriptor> librariesIterator = libraries.iterator();
                while (librariesIterator.hasNext() && library == null) {
                    IDescriptor currentLibrary = librariesIterator.next();
                    if (!libraryId.equals(currentLibrary.getValue("id"))) continue;
                    library = currentLibrary;
                }
            }
            if (library != null) {
                this.getPatternsData(fullId_p, partialId_p.substring(separatorPosition + 1, partialId_p.length()), library, data_p);
            }
        } else if (library_p != null) {
            this.doGetPatternPaths(partialId_p, library_p, data_p);
        } else {
            IDescriptor library = this.getRootLibraryFromId(fullId_p);
            this.resolveLibraryData(library, data_p);
        }
    }

    protected void doGetPatternPaths(String partialId_p, IDescriptor library_p, List<PatternHandler.PatternData> data_p) {
        List children = library_p.getChildren();
        for (IDescriptor currentElement : children) {
            if (!partialId_p.equals(currentElement.getValue("id"))) continue;
            String descriptorType = (String)currentElement.getValue("patternExtType");
            if ("library".equals(descriptorType)) {
                this.resolveLibraryData(currentElement, data_p);
                break;
            }
            PatternHandler.PatternData patternData = this.resolvePatternData(currentElement);
            if (patternData == null) break;
            data_p.add(patternData);
            break;
        }
    }

    protected void resolveLibraryData(IDescriptor library_p, List<PatternHandler.PatternData> data_p) {
        String orchestrationString = (String)library_p.getValue("productionOrchestration");
        String[] ids = null;
        if (orchestrationString != null) {
            ids = StringHelper.getTokens((String)orchestrationString, (String)" ,");
        }
        List elements = library_p.getChildren();
        HashMap<String, IDescriptor> elementsFromId = null;
        if (ids != null) {
            elementsFromId = new HashMap<String, IDescriptor>(elements.size());
            for (IDescriptor element : elements) {
                elementsFromId.put((String)element.getValue("id"), element);
            }
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String currentId = stringArray[n2];
                IDescriptor currentElement = (IDescriptor)elementsFromId.get(currentId);
                this.doResolveLibraryData(currentElement, data_p);
                ++n2;
            }
        } else {
            for (IDescriptor element : elements) {
                this.doResolveLibraryData(element, data_p);
            }
        }
    }

    protected void doResolveLibraryData(IDescriptor libraryChild_p, List<PatternHandler.PatternData> data_p) {
        if (libraryChild_p == null || data_p == null) {
            return;
        }
        String childType = (String)libraryChild_p.getValue("patternExtType");
        if ("library".equals(childType)) {
            this.resolveLibraryData(libraryChild_p, data_p);
        } else {
            PatternHandler.PatternData patternData = this.resolvePatternData(libraryChild_p);
            if (patternData != null) {
                data_p.add(patternData);
            }
        }
    }

    protected PatternHandler.PatternData resolvePatternData(IDescriptor pattern_p) {
        PatternHandler.PatternData result = null;
        String fileDeclaredPath = (String)pattern_p.getValue("model");
        if (fileDeclaredPath == null) {
            return result;
        }
        try {
            result = new PatternHandler().load(fileDeclaredPath);
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("PatternProducer.resolvePatternData(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }
}

