/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.codeassist;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.emf.codegen.jet.editor.util.JETDocumentReader;
import org.eclipse.emf.codegen.jet.editor.util.keywords.JETTemplateDirectiveKeywords;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JETTemplateDirectiveCompletionProcessor
implements IContentAssistProcessor {
    private String[] getAllWords(char c, JETDocumentReader reader) {
        ArrayList<String> all = new ArrayList<String>(20);
        char currChar = c;
        currChar = this.trimBlanksBackward(reader, currChar);
        boolean done = false;
        while (!done) {
            Stack<Character> stack = new Stack<Character>();
            while (currChar != '\uffff' && !Character.isWhitespace(currChar)) {
                stack.push(new Character(currChar));
                currChar = reader.readBackward();
            }
            String s = new String();
            while (!stack.empty()) {
                s = String.valueOf(s) + ((Character)stack.pop()).toString();
            }
            int jspPt = s.indexOf("<%@");
            if (jspPt >= 0) {
                s = s.substring(jspPt + 3);
                done = true;
            }
            all.add(s);
            currChar = this.trimBlanksBackward(reader, currChar);
            if (currChar != '\uffff' && currChar != '@') continue;
            done = true;
        }
        return all.toArray(new String[all.size()]);
    }

    private char trimBlanksBackward(JETDocumentReader reader, char currChar) {
        while (currChar != '\uffff' && Character.isWhitespace(currChar)) {
            currChar = reader.readBackward();
        }
        return currChar;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] result;
        block4: {
            String[] allWords;
            char c;
            block5: {
                block3: {
                    IDocument doc = viewer.getDocument();
                    JETDocumentReader reader = new JETDocumentReader(doc, documentOffset);
                    c = reader.readBackward();
                    result = null;
                    allWords = this.getAllWords(c, reader);
                    if (!Character.isSpaceChar(c)) break block3;
                    String[] nonTagWords = JETTemplateDirectiveKeywords.getInnerKeywordsFor(allWords[allWords.length - 1]);
                    result = new ICompletionProposal[nonTagWords.length];
                    int i = 0;
                    while (i < nonTagWords.length) {
                        result[i] = new CompletionProposal(nonTagWords[i], documentOffset, 0, nonTagWords[i].length());
                        ++i;
                    }
                    break block4;
                }
                if (c != '@') break block5;
                String[] words = JETTemplateDirectiveKeywords.getTags();
                result = new ICompletionProposal[words.length];
                int i = 0;
                while (i < words.length) {
                    result[i] = new CompletionProposal(words[i].substring(allWords[0].length()), documentOffset, 0, words[i].length() - allWords[0].length(), null, words[i], null, null);
                    ++i;
                }
                break block4;
            }
            if (!Character.isLetter(c)) break block4;
            String[] words = allWords.length > 1 ? JETTemplateDirectiveKeywords.getNonTagsKeywordsWithPrefix(allWords[allWords.length - 1], allWords[0]) : JETTemplateDirectiveKeywords.getTagsWithPrefix(allWords[0]);
            result = new ICompletionProposal[words.length];
            int i = 0;
            while (i < words.length) {
                result[i] = new CompletionProposal(words[i].substring(allWords[0].length()), documentOffset, 0, words[i].length() - allWords[0].length(), null, words[i], null, null);
                ++i;
            }
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

