/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.internal.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egf.common.ui.constant.IUiCommonConstants;
import org.eclipse.egf.common.ui.viewers.IOrderedContentProvider;
import org.eclipse.egf.core.ui.internal.viewers.AbstractObservableContentProvider;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class ObservablePatternElementContentProvider
extends AbstractObservableContentProvider
implements IOrderedContentProvider {
    private List<Object> _initialInput;
    private Viewer _viewer;

    protected void handleViewer(Viewer viewer_p) {
        if (this._viewer == null) {
            this._viewer = viewer_p;
        }
    }

    protected void handleElementAdded(Viewer viewer_p, Object addedElements_p) {
        if (addedElements_p instanceof List) {
            this._initialInput = (List)addedElements_p;
        } else {
            this._initialInput.add(addedElements_p);
            AbstractTableViewer abstractListViewer = (AbstractTableViewer)viewer_p;
            abstractListViewer.add(addedElements_p);
            this.updateOrchestration();
        }
    }

    protected void handleElementRemoved(Viewer viewer_p, Object removedElement_p) {
        if (this._initialInput == removedElement_p) {
            return;
        }
        this._initialInput.remove(removedElement_p);
        AbstractTableViewer viewer = (AbstractTableViewer)viewer_p;
        viewer.remove(removedElement_p);
        this.updateOrchestration();
    }

    private void updateOrchestration() {
        this.notifyElementUpdated(new ArrayList<Object>(this._initialInput));
    }

    protected void handleElementUpdated(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
        ((StructuredViewer)viewer_p).refresh(oldInput_p);
        this.notifyElementUpdated(Collections.singletonList(oldInput_p));
    }

    public Object[] getElements(Object inputElement_p) {
        Object[] result = null;
        result = this._initialInput != null ? this._initialInput.toArray() : IUiCommonConstants.NO_ELEMENT;
        return result;
    }

    public void swap(int elementPosition1_p, int elementPosition2_p) {
        Collections.swap(this._initialInput, elementPosition1_p, elementPosition2_p);
        this.getViewer().refresh();
        this.updateOrchestration();
    }

    protected Viewer getViewer() {
        return this._viewer;
    }
}

