/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.data.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.core.ui.data.explorer.FactoryComponentWorkingSet;
import org.eclipse.egf.core.ui.data.explorer.adapter.Messages;
import org.eclipse.egf.core.ui.data.listener.IWorkingSetListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.workingsets.OthersWorkingSetUpdater;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryComponentWorkingSetManager
implements IAdaptable,
IPropertyChangeListener {
    private static final String OTHER_PROJECTS_WORKING_SET_ID = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    private List<FactoryComponentWorkingSet> _workingSets;
    private List<IWorkingSetListener> _workingSetListeners = new ArrayList<IWorkingSetListener>(1);
    private ILocalWorkingSetManager _localWorkingSetManager;
    private FactoryComponentWorkingSet _otherFcs;

    public void dispose() {
        if (this._localWorkingSetManager != null) {
            this._localWorkingSetManager.dispose();
            this._localWorkingSetManager = null;
        }
    }

    public Object getAdapter(Class adapter_p) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter_p);
    }

    protected IWorkingSetManager getWorkingsetManager() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkingSetManager workingSetManager = workbench.getWorkingSetManager();
        return workingSetManager;
    }

    public synchronized Collection<FactoryComponentWorkingSet> getAllWorkingSets() {
        if (this._workingSets == null) {
            IWorkingSetManager workingSetManager = this.getWorkingsetManager();
            IWorkingSet[] workingSets = workingSetManager.getWorkingSets();
            if (workingSets.length > 0) {
                int i = 0;
                while (i < workingSets.length) {
                    IWorkingSet currentWorkingSet = workingSets[i];
                    this.addWorkingSet(currentWorkingSet);
                    ++i;
                }
            }
            this._localWorkingSetManager = PlatformUI.getWorkbench().createLocalWorkingSetManager();
            IWorkingSet others = this._localWorkingSetManager.createWorkingSet(Messages.FactoryComponentWorkingSetManager_OtherWorkingSet_Title, new IAdaptable[0]);
            others.setId(OTHER_PROJECTS_WORKING_SET_ID);
            this._localWorkingSetManager.addWorkingSet(others);
            this._otherFcs = this.addWorkingSet(others);
        }
        return new ArrayList<FactoryComponentWorkingSet>(this._workingSets);
    }

    public synchronized Collection<FactoryComponentWorkingSet> getPublicWorkingSets() {
        ArrayList<FactoryComponentWorkingSet> workingSets = new ArrayList<FactoryComponentWorkingSet>(this._workingSets);
        workingSets.remove(this._otherFcs);
        return workingSets;
    }

    public synchronized void updatePublicWorkingSetsOrder(List<IWorkingSet> upToDateWorkingSets_p) {
        ArrayList<FactoryComponentWorkingSet> upToDateFcWorkingSets = new ArrayList<FactoryComponentWorkingSet>(upToDateWorkingSets_p.size());
        for (IWorkingSet currentWorkingSet : upToDateWorkingSets_p) {
            FactoryComponentWorkingSet relatedFcWorkingSet = this.getFactoryComponentWorkingSet(currentWorkingSet);
            if (relatedFcWorkingSet != null) {
                upToDateFcWorkingSets.add(relatedFcWorkingSet);
                continue;
            }
            if (currentWorkingSet instanceof OthersWorkingSetUpdater) {
                upToDateFcWorkingSets.add(this._otherFcs);
                continue;
            }
            FactoryComponentWorkingSet fcWorkingSet = new FactoryComponentWorkingSet(currentWorkingSet);
            upToDateFcWorkingSets.add(fcWorkingSet);
        }
        this._workingSets = upToDateFcWorkingSets;
    }

    public FactoryComponentWorkingSet getOtherFcsWorkingSet() {
        return this._otherFcs;
    }

    private synchronized FactoryComponentWorkingSet addWorkingSet(IWorkingSet workingSet_p) {
        if (this._workingSets == null) {
            this._workingSets = new ArrayList<FactoryComponentWorkingSet>(1);
        }
        FactoryComponentWorkingSet fcWorkingSet = new FactoryComponentWorkingSet(workingSet_p);
        this._workingSets.add(fcWorkingSet);
        return fcWorkingSet;
    }

    private synchronized FactoryComponentWorkingSet removeWorkingSet(IWorkingSet workingSet_p) {
        FactoryComponentWorkingSet removedWorkingSet = null;
        if (this._workingSets != null) {
            Iterator<FactoryComponentWorkingSet> iter = this._workingSets.iterator();
            while (iter.hasNext() && removedWorkingSet == null) {
                FactoryComponentWorkingSet fcWorkingSet = iter.next();
                if (!workingSet_p.equals(fcWorkingSet.getWorkingSet())) continue;
                removedWorkingSet = fcWorkingSet;
                iter.remove();
            }
        }
        return removedWorkingSet;
    }

    public synchronized FactoryComponentWorkingSet getFactoryComponentWorkingSet(IWorkingSet workingSet_p) {
        FactoryComponentWorkingSet result = null;
        if (this._workingSets != null) {
            Iterator<FactoryComponentWorkingSet> iter = this._workingSets.iterator();
            while (iter.hasNext() && result == null) {
                FactoryComponentWorkingSet fcWorkingSet = iter.next();
                if (!workingSet_p.equals(fcWorkingSet.getWorkingSet())) continue;
                result = fcWorkingSet;
            }
        }
        return result;
    }

    public void addWorkingSetListener(IWorkingSetListener listener_p) {
        this._workingSetListeners.add(listener_p);
    }

    public void removeWorkingSetListener(IWorkingSetListener listener_p) {
        this._workingSetListeners.remove(listener_p);
    }

    private void notifyListeners(Notifier notifier_p) {
        Iterator<IWorkingSetListener> iter = this._workingSetListeners.iterator();
        while (iter.hasNext()) {
            notifier_p.setListener(iter.next());
            notifier_p.run();
        }
    }

    public void propertyChange(PropertyChangeEvent event_p) {
        String property = event_p.getProperty();
        if ("workingSetContentChange".equals(property)) {
            IWorkingSet workingSet = (IWorkingSet)event_p.getNewValue();
            this.handleWorkingSetContentChanged(workingSet, event_p);
        } else if ("workingSetRemove".equals(property)) {
            IWorkingSet workingSet = (IWorkingSet)event_p.getOldValue();
            this.handleWorkingSetRemoved(workingSet, event_p);
        } else if ("workingSetAdd".equals(property)) {
            IWorkingSet workingSet = (IWorkingSet)event_p.getNewValue();
            this.handleWorkingSetAdded(workingSet, event_p);
        } else if ("workingSetNameChange".equals(property)) {
            IWorkingSet workingSet = (IWorkingSet)event_p.getNewValue();
            this.handleWorkingSetNameChanged(workingSet, event_p);
        } else if ("workingSetLabelChange".equals(property)) {
            IWorkingSet workingSet = (IWorkingSet)event_p.getNewValue();
            this.handleWorkingSetLabelChanged(workingSet, event_p);
        } else if ("workingSetModelChanged".equals(property)) {
            this.handleWorkingSetModelContentChanged(event_p);
        }
    }

    protected void handleWorkingSetModelContentChanged(final PropertyChangeEvent event_p) {
        this.notifyListeners(new Notifier(){

            public void run() {
                this.getListener().workingSetModelChanged(event_p);
            }
        });
    }

    protected void handleWorkingSetAdded(IWorkingSet workingSet_p, final PropertyChangeEvent event_p) {
        final FactoryComponentWorkingSet addedWorkingSet = this.addWorkingSet(workingSet_p);
        this.notifyListeners(new Notifier(){

            public void run() {
                this.getListener().workingSetAdded(addedWorkingSet, event_p);
            }
        });
    }

    protected void handleWorkingSetContentChanged(IWorkingSet workingSet_p, final PropertyChangeEvent event_p) {
        final FactoryComponentWorkingSet modifiedWorkingSet = this.getFactoryComponentWorkingSet(workingSet_p);
        if (modifiedWorkingSet != null) {
            this.notifyListeners(new Notifier(){

                public void run() {
                    this.getListener().workingSetContentChanged(modifiedWorkingSet, event_p);
                }
            });
        }
    }

    protected void handleWorkingSetLabelChanged(IWorkingSet workingSet_p, final PropertyChangeEvent event_p) {
        final FactoryComponentWorkingSet modifiedWorkingSet = this.getFactoryComponentWorkingSet(workingSet_p);
        this.notifyListeners(new Notifier(){

            public void run() {
                this.getListener().workingSetLabelChanged(modifiedWorkingSet, event_p);
            }
        });
    }

    protected void handleWorkingSetNameChanged(IWorkingSet workingSet_p, final PropertyChangeEvent event_p) {
        final FactoryComponentWorkingSet modifiedWorkingSet = this.getFactoryComponentWorkingSet(workingSet_p);
        this.notifyListeners(new Notifier(){

            public void run() {
                this.getListener().workingSetNameChanged(modifiedWorkingSet, event_p);
            }
        });
    }

    protected void handleWorkingSetRemoved(IWorkingSet workingSet_p, final PropertyChangeEvent event_p) {
        final FactoryComponentWorkingSet removedWorkingSet = this.removeWorkingSet(workingSet_p);
        this.notifyListeners(new Notifier(){

            public void run() {
                this.getListener().workingSetRemoved(removedWorkingSet, event_p);
            }
        });
    }

    public FactoryComponentWorkingSet getParent(IProject project_p) {
        FactoryComponentWorkingSet result = null;
        Iterator<FactoryComponentWorkingSet> allWorkingSets = this.getAllWorkingSets().iterator();
        while (allWorkingSets.hasNext() && result == null) {
            FactoryComponentWorkingSet currentFcWorkingSet = allWorkingSets.next();
            IAdaptable[] elements = currentFcWorkingSet.getWorkingSet().getElements();
            if (!FactoryComponentWorkingSetManager.getProjects(elements).contains(project_p)) continue;
            result = currentFcWorkingSet;
        }
        if (result == null) {
            result = this.getOtherFcsWorkingSet();
        }
        return result;
    }

    public static List<IProject> getProjects(IAdaptable[] elements_p) {
        ArrayList<IProject> projects = new ArrayList<IProject>(0);
        int i = 0;
        while (i < elements_p.length) {
            IAdaptable adaptable = elements_p[i];
            if (adaptable instanceof IJavaProject) {
                projects.add(((IJavaProject)adaptable).getProject());
            }
            ++i;
        }
        return projects;
    }

    abstract class Notifier
    implements Runnable {
        private IWorkingSetListener _listener;

        Notifier() {
        }

        public void setListener(IWorkingSetListener listener_p) {
            this._listener = listener_p;
        }

        protected IWorkingSetListener getListener() {
            return this._listener;
        }
    }
}

