/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fc.generator.java.task;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.task.AbstractTask;
import org.eclipse.egf.fc.generator.java.internal.GenerateJavaCodeOperation;
import org.eclipse.egf.fc.generator.java.model.AbstractGenModelGenerator;
import org.eclipse.egf.fc.generator.java.model.AbstractGenModelGeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;

public class GeneratorJavaTask
extends AbstractTask {
    static final Logger __logger = Logger.getLogger((String)GeneratorJavaTask.class.getPackage().getName());
    private static final String EMF_ROOT_INTERFACE = "emfRootInterface";
    private static final String EMF_ROOT_CLASS = "emfRootClass";
    private static final String JDK_COMPLIANCE_LEVEL = "jdkComplianceLevel";
    private static final String GEN_MODEL_GENERATOR = "genModelGenerator";
    private static final String GENERATOR_ADAPTER_FACTORY = "generatorAdapterFactory";
    private static final String MERGE_RULES_RELATIVE_PATH = "mergeRulesPath";
    private static final String BASE_PACKAGE = "basePackage";
    private static final String FACTORY_COMPONENT_PROJECT_NAME = "assetProjectName";
    private static final String INPUT_PATH = "inputPath";
    private static final String MODEL_DIRECTORY = "modelDirectory";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String IMPL_PACKAGE_SUFFIX = "implementationPackageSuffix";
    private static final String INTERFACE_PACKAGE_SUFFIX = "interfacePackageSuffix";
    private static final String METADATA_PACKAGE_SUFFIX = "metadataPackageSuffix";
    private static final String UTILITY_PACKAGE_SUFFIX = "utilityPackageSuffix";

    protected boolean doExecute(IProgressMonitor progressMonitor_p) {
        String utilityPackageSuffix;
        String metadataPackageSuffix;
        String interfacePackageSuffix;
        String implementationPackageSuffix;
        GenResourceKind resourceType;
        String modelDirectory;
        AbstractGenModelGeneratorAdapterFactory generatorAdapterFactory;
        GenJDKLevel jdkComplianceLevel;
        String emfRootClass;
        GenerateJavaCodeOperation generateJavaCodeOperation = new GenerateJavaCodeOperation(this.getInputPath(), this.getFactoryComponentProjectName(), this.getBasePackage(), this.getGenModelGenerator());
        String emfRootInterface = this.getEmfRootInterface();
        if (emfRootInterface != null) {
            generateJavaCodeOperation.setRootExtendsInterface(emfRootInterface);
        }
        if ((emfRootClass = this.getEmfRootClass()) != null) {
            generateJavaCodeOperation.setRootExtendsClass(emfRootClass);
        }
        if ((jdkComplianceLevel = this.getJdkComplianceLevel()) != null) {
            generateJavaCodeOperation.setJdkComplianceLevel(jdkComplianceLevel);
        }
        if ((generatorAdapterFactory = this.getGeneratorAdapterFactory()) != null) {
            generateJavaCodeOperation.setGeneratorAdapterFactory((GeneratorAdapterFactory)generatorAdapterFactory);
            String mergeRulesPath = this.getMergeRulesRelativePath();
            if (mergeRulesPath != null) {
                generatorAdapterFactory.setMergeRulesRelativePath(mergeRulesPath);
            }
        }
        if ((modelDirectory = this.getModelDirectory()) != null) {
            generateJavaCodeOperation.setModelDirectory(modelDirectory);
        }
        if ((resourceType = this.getResourceType()) != null) {
            generateJavaCodeOperation.setResourceType(resourceType);
        }
        if ((implementationPackageSuffix = this.getImplementationPackageSuffix()) != null) {
            generateJavaCodeOperation.setImplementationPackageSuffix(implementationPackageSuffix);
        }
        if ((interfacePackageSuffix = this.getInterfacePackageSuffix()) != null) {
            generateJavaCodeOperation.setInterfacePackageSuffix(interfacePackageSuffix);
        }
        if ((metadataPackageSuffix = this.getMetadataPackageSuffix()) != null) {
            generateJavaCodeOperation.setMetadataPackageSuffix(metadataPackageSuffix);
        }
        if ((utilityPackageSuffix = this.getUtilityPackageSuffix()) != null) {
            generateJavaCodeOperation.setUtilityPackageSuffix(utilityPackageSuffix);
        }
        try {
            generateJavaCodeOperation.run(progressMonitor_p);
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("GeneratorJavaTask.doExecute(..) _ ");
            loggerMessage.append("Failed to generate java code for ").append(this.getFactoryComponentProjectName());
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return generateJavaCodeOperation.getResult();
    }

    private IPath getInputPath() {
        String modelName = (String)this.getContextElementValue(INPUT_PATH);
        String rootPrefix = null;
        rootPrefix = modelName.charAt(0) == '/' ? "" : String.valueOf('/');
        return new Path(String.valueOf(rootPrefix) + modelName);
    }

    private String getFactoryComponentProjectName() {
        return (String)this.getContextElementValue(FACTORY_COMPONENT_PROJECT_NAME);
    }

    private String getBasePackage() {
        return (String)this.getContextElementValue(BASE_PACKAGE);
    }

    private String getEmfRootInterface() {
        return (String)this.getContextElementValue(EMF_ROOT_INTERFACE);
    }

    private String getEmfRootClass() {
        return (String)this.getContextElementValue(EMF_ROOT_CLASS);
    }

    private GenJDKLevel getJdkComplianceLevel() {
        return (GenJDKLevel)this.getContextElementValue(JDK_COMPLIANCE_LEVEL);
    }

    private GenResourceKind getResourceType() {
        return (GenResourceKind)this.getContextElementValue(RESOURCE_TYPE);
    }

    private String getModelDirectory() {
        return (String)this.getContextElementValue(MODEL_DIRECTORY);
    }

    private AbstractGenModelGenerator getGenModelGenerator() {
        return (AbstractGenModelGenerator)this.getContextElementValue(GEN_MODEL_GENERATOR);
    }

    private AbstractGenModelGeneratorAdapterFactory getGeneratorAdapterFactory() {
        return (AbstractGenModelGeneratorAdapterFactory)((Object)this.getContextElementValue(GENERATOR_ADAPTER_FACTORY));
    }

    private String getMergeRulesRelativePath() {
        return (String)this.getContextElementValue(MERGE_RULES_RELATIVE_PATH);
    }

    private String getImplementationPackageSuffix() {
        return (String)this.getContextElementValue(IMPL_PACKAGE_SUFFIX);
    }

    private String getInterfacePackageSuffix() {
        return (String)this.getContextElementValue(INTERFACE_PACKAGE_SUFFIX);
    }

    private String getMetadataPackageSuffix() {
        return (String)this.getContextElementValue(METADATA_PACKAGE_SUFFIX);
    }

    private String getUtilityPackageSuffix() {
        return (String)this.getContextElementValue(UTILITY_PACKAGE_SUFFIX);
    }
}

