/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.navigator;

import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.core.ui.workbench.EgfWorkbenchActivator;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.navigator.AbstractModelElementAction;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateElementAction
extends AbstractModelElementAction {
    private boolean _isValidationOnError;
    private boolean _reportSuccessfulValidation;
    private String _errorDialogTitle;

    public ValidateElementAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
        this.setId("org.eclipse.egf.core.ui.workbench.action.navigator.validate");
        this.setText(Messages.ValidateElementAction_Title);
        this.setToolTipText(Messages.ValidateElementAction_Tooltip);
        this.setImageDescriptor(EgfWorkbenchActivator.getDefault().getImageDescriptor("obj16/validate.gif"));
        this._reportSuccessfulValidation = true;
    }

    public ValidateElementAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p, boolean reportSuccessfulValidation_p) {
        this(shell_p, selectionProvider_p, readOnlyMode_p);
        this._reportSuccessfulValidation = reportSuccessfulValidation_p;
    }

    @Override
    protected Wizard getWizardFor(NamedModelElementWithId selectedModelElement_p) {
        return null;
    }

    @Override
    protected Class<?> getModelElementClass() {
        return NamedModelElementWithId.class;
    }

    public void run() {
        NamedModelElementWithId modelElement = this.getModelElement();
        Object[] data = new Object[]{modelElement};
        String elementName = modelElement.getName();
        elementName = elementName != null ? elementName : modelElement.eClass().getName();
        String formattedMessage = StringHelper.formatMessage((String)Messages.ValidateElementAction_Error_Detailed_Message, (Object[])new String[]{elementName});
        BasicDiagnostic diagnosticChain = new BasicDiagnostic("org.eclipse.emf.ecore", 0, formattedMessage, data);
        Diagnostician diagnostician = new Diagnostician();
        Diagnostic diagnostic = diagnostician.validate((EObject)modelElement);
        boolean bl = this._isValidationOnError = 4 == diagnostic.getSeverity();
        if (this._isValidationOnError) {
            diagnosticChain.addAll(diagnostic);
            String formattedTitle = this.getErrorDialogTitle();
            DiagnosticDialog.open((Shell)this.getShell(), (String)formattedTitle, (String)Messages.ValidateElementAction_Error_Overall_Message, (Diagnostic)((Diagnostic)diagnosticChain));
        } else if (this._reportSuccessfulValidation) {
            String formattedTitle = StringHelper.formatMessage((String)Messages.ValidateElementAction_ValidationReportDialog_Title, (Object[])new String[]{Messages.ValidateElementAction_ValidationReportDialog_Title_Info});
            MessageDialog.openInformation((Shell)this.getShell(), (String)formattedTitle, (String)Messages.ValidateElementAction_NoError_Message);
        }
    }

    protected String getErrorDialogTitle() {
        return this._errorDialogTitle == null ? this.getDefaultErrorDialogTitle() : this._errorDialogTitle;
    }

    protected String getDefaultErrorDialogTitle() {
        String formattedTitle = StringHelper.formatMessage((String)Messages.ValidateElementAction_ValidationReportDialog_Title, (Object[])new String[]{Messages.ValidateElementAction_ValidationReportDialog_Title_Problem});
        return formattedTitle;
    }

    public boolean isValid() {
        return !this._isValidationOnError;
    }

    public boolean isEnabled() {
        boolean result = super.isEnabled();
        NamedModelElementWithId modelElement = this.getModelElement();
        if (modelElement instanceof PatternModel) {
            result = false;
        }
        return result;
    }

    public void setErrorDialogTitle(String errorDialogTitle_p) {
        this._errorDialogTitle = errorDialogTitle_p;
    }
}

