/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.refactoring.internal.move.change;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egf.common.helper.PatternHelper;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.PatternViewpoint;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.refactoring.internal.move.change.Messages;
import org.eclipse.egf.pattern.refactoring.internal.move.change.RefactoringPatternHandler;
import org.eclipse.egf.pattern.refactoring.move.MoveInfo;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class PatternElementChange
extends Change {
    private static final Logger __logger = Logger.getLogger((String)PatternElementChange.class.getPackage().getName());
    private MoveInfo _moveInfo;

    protected PatternElementChange(MoveInfo info_p) {
        Assert.isNotNull((Object)info_p);
        this._moveInfo = info_p;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return StringHelper.formatMessage((String)Messages.PatternElementChange_Name, (Object[])new Object[]{this._moveInfo.getFirstElementToMove().getName(), this._moveInfo.getDestinationElement().getName()});
    }

    public void initializeValidationData(IProgressMonitor pm_p) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm_p) throws CoreException, OperationCanceledException {
        NamedModelElementWithId destinationElement;
        RefactoringStatus status = new RefactoringStatus();
        AbstractPatternElement element = this._moveInfo.getFirstElementToMove();
        if (element == null) {
            status.addError(Messages.PatternElementChange_Error_NoElement);
        }
        if ((destinationElement = this._moveInfo.getDestinationElement()) == null) {
            status.addError(Messages.PatternElementChange_Error_NoDestinationElement);
        }
        return status;
    }

    public Change perform(IProgressMonitor pm_p) throws CoreException {
        AbstractPatternElement elementToMove = this._moveInfo.getFirstElementToMove();
        NamedModelElementWithId destinationElement = this._moveInfo.getDestinationElement();
        NamedModelElementWithId previousContainingElement = (NamedModelElementWithId)elementToMove.eContainer();
        Change undoChange = PatternElementChange.createPatternElementChange(previousContainingElement, elementToMove);
        AdapterFactoryEditingDomain editingDomain = EgfUiActivator.getDefault().getEditingDomain();
        CommandStack commandStack = editingDomain.getCommandStack();
        Command removeCommand = this.createRemoveFromContainerCommand((EditingDomain)editingDomain, previousContainingElement, elementToMove);
        if (removeCommand != null) {
            commandStack.execute(removeCommand);
        }
        this.updateModels(elementToMove, previousContainingElement, destinationElement);
        Command addRemoveCommand = this.createAddCommandToContainer((EditingDomain)editingDomain, destinationElement, elementToMove);
        if (addRemoveCommand != null) {
            commandStack.execute(addRemoveCommand);
        }
        return undoChange;
    }

    protected EReference getReferenceForContainer(NamedModelElementWithId container_p) {
        EReference result = null;
        if (container_p instanceof PatternLibrary) {
            result = ModelPackage.Literals.PATTERN_LIBRARY__PATTERN_ELEMENTS;
        } else if (container_p instanceof PatternViewpoint) {
            result = ModelPackage.Literals.PATTERN_VIEWPOINT__LIBRARIES;
        }
        return result;
    }

    protected Command createRemoveFromContainerCommand(EditingDomain editingDomain_p, NamedModelElementWithId container_p, AbstractPatternElement elementToMove_p) {
        Command result = null;
        EReference reference = this.getReferenceForContainer(container_p);
        if (reference != null) {
            result = RemoveCommand.create((EditingDomain)editingDomain_p, (Object)container_p, (Object)reference, (Object)elementToMove_p);
        }
        return result;
    }

    protected Command createAddCommandToContainer(EditingDomain editingDomain_p, NamedModelElementWithId destinationContainer_p, AbstractPatternElement elementToMove_p) {
        Command result = null;
        EReference reference = this.getReferenceForContainer(destinationContainer_p);
        if (reference != null) {
            result = AddCommand.create((EditingDomain)editingDomain_p, (Object)destinationContainer_p, (Object)reference, (Object)elementToMove_p);
        }
        return result;
    }

    protected void updateModels(AbstractPatternElement elementToMove_p, NamedModelElementWithId previousContainingElement_p, NamedModelElementWithId destinationElement_p) {
        String previousFcId = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)previousContainingElement_p).getId();
        String destinationFcId = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)destinationElement_p).getId();
        String rootId = null;
        if (destinationElement_p instanceof PatternLibrary) {
            rootId = destinationElement_p.getId();
        }
        this.updateElement(elementToMove_p, rootId, previousFcId, destinationFcId);
    }

    protected void updateElement(AbstractPatternElement patternElement_p, String parentFullId_p, String previousFcId_p, String destinationFcId_p) {
        block9: {
            String newId;
            block8: {
                String elementFullId = patternElement_p.getId();
                newId = PatternHelper.getFullId((String)parentFullId_p, (String)((String)PatternHelper.deresolveId((String)elementFullId).getValue()));
                patternElement_p.setId(newId);
                if (!(patternElement_p instanceof PatternLibrary)) break block8;
                EList patternElements = ((PatternLibrary)patternElement_p).getPatternElements();
                for (AbstractPatternElement abstractPatternElement : patternElements) {
                    this.updateElement(abstractPatternElement, newId, previousFcId_p, destinationFcId_p);
                }
                break block9;
            }
            if (!(patternElement_p instanceof PatternModel)) break block9;
            PatternModel patternModel = (PatternModel)patternElement_p;
            RefactoringPatternHandler handler = new RefactoringPatternHandler();
            PatternHandler.PatternData patternData = null;
            try {
                patternData = handler.load(patternModel.getPath());
            }
            catch (Exception exception) {
                patternData = null;
            }
            if (patternData != null) {
                try {
                    if (!previousFcId_p.equals(destinationFcId_p)) {
                        handler.cleanGeneratedStructures();
                        handler.refactorContainingFactoryComponent(previousFcId_p, destinationFcId_p);
                        handler.refactorFullId(newId, false);
                    } else {
                        handler.refactorFullId(newId, true);
                    }
                    handler.save(patternModel);
                }
                catch (Exception e_p) {
                    StringBuilder loggerMessage = new StringBuilder("PatternElementChange.updateElement(..) _ ");
                    loggerMessage.append("Unable to update element ").append(patternElement_p.getName());
                    __logger.error((Object)loggerMessage.toString(), (Throwable)e_p);
                }
            }
        }
    }

    public static Change createPatternElementChange(NamedModelElementWithId destinationElement_p, AbstractPatternElement patternElement_p) {
        Assert.isNotNull((Object)patternElement_p);
        Assert.isNotNull((Object)destinationElement_p);
        MoveInfo info = new MoveInfo();
        info.setDestinationElement(destinationElement_p);
        info.addElementToMove(patternElement_p);
        return new PatternElementChange(info);
    }
}

