/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.data.validation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.core.data.validation.Messages;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.util.ModelSwitch;
import org.eclipse.egf.model.validation.IDelegatedValidator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementDelegatedValidator
implements IDelegatedValidator {
    private static final Logger __logger = Logger.getLogger((String)ModelElementDelegatedValidator.class.getPackage().getName());
    private DiagnosticChain _diagnostics;
    private ModelSwitch<Boolean> _modelSwitch;

    public ModelElementDelegatedValidator() {
        this.initializeModelSwitch();
    }

    protected void initializeModelSwitch() {
        this._modelSwitch = new ModelSwitch<Boolean>(){

            public Boolean caseFactoryComponentInvocation(FactoryComponentInvocation fcInvocation_p) {
                if (__logger.isDebugEnabled()) {
                    StringBuilder loggerMessage = new StringBuilder(".caseFactoryComponentInvocation(..) _ ");
                    __logger.debug((Object)loggerMessage.toString());
                }
                boolean valid = true;
                String referencedFcId = fcInvocation_p.getFactoryComponentId();
                FactoryComponent referencedFc = CoreActivator.getDefault().getFactoryComponent(referencedFcId);
                if (referencedFc == null) {
                    valid = false;
                    ModelElementDelegatedValidator.this.getDiagnostics().add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.egf.model", 0, StringHelper.formatMessage((String)Messages.ModelElementDelegatedValidator_FactoryComponentInvocation_Rule0_Message, (Object[])new Object[]{fcInvocation_p.getName(), referencedFcId}), new Object[]{fcInvocation_p}));
                } else if (DataHelper.isBootstrapFactoryComponent(referencedFcId)) {
                    valid = ModelElementDelegatedValidator.this.checkFactoryComponentInvocationReferencingRootFc(fcInvocation_p);
                } else {
                    boolean validationError;
                    valid = ModelElementDelegatedValidator.this.checkFactoryComponentInvocationHasAllMandatoryContractFilled(fcInvocation_p, referencedFc);
                    Diagnostician diagnostician = new Diagnostician();
                    Diagnostic diagnostic = diagnostician.validate((EObject)referencedFc);
                    boolean bl = validationError = 4 == diagnostic.getSeverity();
                    if (validationError) {
                        valid = false;
                        String formattedMessage = StringHelper.formatMessage((String)Messages.ModelElementDelegatedValidator_FactoryComponentInvocation_ReferencedFcDiagnostic_Message, (Object[])new String[]{referencedFc.getName()});
                        BasicDiagnostic referencedFcDiagnostic = new BasicDiagnostic(4, "org.eclipse.egf.model", 0, formattedMessage, new Object[]{referencedFc});
                        referencedFcDiagnostic.addAll(diagnostic);
                        ModelElementDelegatedValidator.this.getDiagnostics().add((Diagnostic)referencedFcDiagnostic);
                    }
                }
                return valid;
            }

            public Boolean caseContractElementReference(ContractElementReference contractElementReference_p) {
                if (__logger.isDebugEnabled()) {
                    StringBuilder loggerMessage = new StringBuilder(".caseContractElementReference(..) _ ");
                    __logger.debug((Object)loggerMessage.toString());
                }
                boolean valid = true;
                valid = ModelElementDelegatedValidator.this.checkContractElementRefPointsExpectedFactoryComponent(contractElementReference_p);
                if (valid) {
                    valid = ModelElementDelegatedValidator.this.checkContractElementRefPointsExistingFactoryComponent(contractElementReference_p);
                }
                if (valid) {
                    ContractElement initialReferencedContractElement = contractElementReference_p.getReferencedContractElement();
                    try {
                        contractElementReference_p.setReferencedContractElement(null);
                        DataHelper.resolveContractElement(contractElementReference_p);
                        ContractElement reloadedReferencedContractElement = contractElementReference_p.getReferencedContractElement();
                        if (reloadedReferencedContractElement == null) {
                            valid = false;
                            String referencedContractElementIdentifier = contractElementReference_p.getReferencedContractElementId();
                            ModelElementDelegatedValidator.this.addErrorForContractElementRef(contractElementReference_p, Messages.ModelElementDelegatedValidator_ContractElementReference_Rule3_Message, new Object[]{referencedContractElementIdentifier});
                        }
                    }
                    finally {
                        contractElementReference_p.setReferencedContractElement(initialReferencedContractElement);
                    }
                }
                return valid;
            }

            public Boolean defaultCase(EObject object_p) {
                if (__logger.isDebugEnabled()) {
                    StringBuilder loggerMessage = new StringBuilder(".defaultCase(..) _ ");
                    loggerMessage.append(object_p.eClass().getName());
                    __logger.debug((Object)loggerMessage.toString());
                }
                return Boolean.TRUE;
            }
        };
    }

    protected void addErrorForContractElementRef(ContractElementReference contractElementReference_p, String detailedMessage_p, Object[] detailedMessageArgs_p) {
        NamedModelElementWithId contractElementRefContainer = (NamedModelElementWithId)contractElementReference_p.eContainer();
        String bodyMessage = StringHelper.formatMessage((String)Messages.ModelElementDelegatedValidator_ContractElementReference_MessageHeader, (Object[])new Object[]{contractElementRefContainer.eClass().getName(), contractElementRefContainer.getId()});
        String detailedFormatedMessage = StringHelper.formatMessage((String)detailedMessage_p, (Object[])detailedMessageArgs_p);
        this.getDiagnostics().add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.egf.model", 0, String.valueOf(bodyMessage) + detailedFormatedMessage, new Object[]{contractElementRefContainer}));
    }

    protected boolean checkFactoryComponentInvocationHasAllMandatoryContractFilled(FactoryComponentInvocation fcInvocation_p, FactoryComponent referencedFc_p) {
        boolean valid = true;
        List<ContractElement> mandatoryContractElements = DataHelper.getMandatoryContractElementWithNoDefaultValue(referencedFc_p);
        FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)fcInvocation_p);
        Contract localContract = ModelHelper.getContract((FactoryComponent)fcContainer);
        Collection<ContractElement> referencedContractElementsByLocalContract = DataHelper.getReferencedContractElementsFor(localContract);
        mandatoryContractElements.removeAll(referencedContractElementsByLocalContract);
        if (!mandatoryContractElements.isEmpty()) {
            Context localContext = fcInvocation_p.getContext();
            Collection<ContractElement> referencedContractElementsByLocalContext = DataHelper.getReferencedContractElementsFor(localContext);
            mandatoryContractElements.removeAll(referencedContractElementsByLocalContext);
        }
        if (!mandatoryContractElements.isEmpty()) {
            valid = false;
            for (ContractElement contractElement : mandatoryContractElements) {
                this.getDiagnostics().add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.egf.model", 0, StringHelper.formatMessage((String)Messages.ModelElementDelegatedValidator_FactoryComponentInvocation_Rule2_Message, (Object[])new Object[]{fcInvocation_p.getName(), referencedFc_p.getName(), contractElement.getName()}), new Object[]{fcInvocation_p}));
            }
        }
        return valid;
    }

    protected boolean checkContractElementRefPointsExistingFactoryComponent(ContractElementReference contractElementReference_p) {
        boolean valid = true;
        String referencedFcId = contractElementReference_p.getReferencedFactoryComponentId();
        FactoryComponent referencedFc = CoreActivator.getDefault().getFactoryComponent(referencedFcId);
        if (referencedFc == null) {
            valid = false;
            this.addErrorForContractElementRef(contractElementReference_p, Messages.ModelElementDelegatedValidator_ContractElementReference_Rule2_Message, new Object[]{referencedFcId});
        }
        return valid;
    }

    protected boolean checkContractElementRefPointsExpectedFactoryComponent(ContractElementReference contractElementReference_p) {
        boolean valid = true;
        String referencedFcIdByContractElementRef = contractElementReference_p.getReferencedFactoryComponentId();
        EObject owner = contractElementReference_p.eContainer();
        if (owner instanceof ContextElement) {
            FactoryComponentInvocation fcInvocation;
            String referencedFcId;
            if ((owner = owner.eContainer().eContainer()) instanceof FactoryComponentInvocation && !(referencedFcId = (fcInvocation = (FactoryComponentInvocation)owner).getFactoryComponentId()).equals(referencedFcIdByContractElementRef)) {
                valid = false;
                this.addErrorForContractElementRef(contractElementReference_p, Messages.ModelElementDelegatedValidator_ContractElementReference_Rule0_Message, new Object[]{fcInvocation.getName()});
            }
        } else if (owner instanceof ContractElement) {
            FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)contractElementReference_p);
            ProductionPlan productionPlan = ModelHelper.getProductionPlan((FactoryComponent)fcContainer);
            boolean found = false;
            Iterator iter = productionPlan.getFactoryComponentInvocations().iterator();
            while (iter.hasNext() && !found) {
                FactoryComponentInvocation currentFc = (FactoryComponentInvocation)iter.next();
                if (!currentFc.getFactoryComponentId().equals(referencedFcIdByContractElementRef)) continue;
                found = true;
            }
            if (!found) {
                valid = false;
                this.addErrorForContractElementRef(contractElementReference_p, Messages.ModelElementDelegatedValidator_ContractElementReference_Rule1_Message, new Object[]{contractElementReference_p.getReferencedContractElementId(), referencedFcIdByContractElementRef});
            }
        }
        return valid;
    }

    protected boolean checkFactoryComponentInvocationReferencingRootFc(FactoryComponentInvocation fcInvocation_p) {
        boolean valid = true;
        if (fcInvocation_p.getTaskFactory() == null) {
            this.getDiagnostics().add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.egf.model", 0, StringHelper.formatMessage((String)Messages.ModelElementDelegatedValidator_FactoryComponentInvocation_Rule1_Message, (Object[])new Object[]{fcInvocation_p.getName()}), new Object[]{fcInvocation_p}));
        }
        return valid;
    }

    public boolean validate(NamedModelElementWithId modelElement_p, DiagnosticChain diagnostics_p, Map<Object, Object> context_p) {
        boolean valid = false;
        if (!(diagnostics_p instanceof Diagnostic)) {
            return valid;
        }
        this._diagnostics = diagnostics_p;
        Diagnostic diagnostics = (Diagnostic)diagnostics_p;
        int initialDiagnosticCount = diagnostics.getChildren().size();
        this._modelSwitch.doSwitch((EObject)modelElement_p);
        int diagnosticCount = diagnostics.getChildren().size();
        valid = diagnosticCount > initialDiagnosticCount;
        return valid;
    }

    protected DiagnosticChain getDiagnostics() {
        return this._diagnostics;
    }
}

