/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.edit.command.plugin.context;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.edit.command.plugin.PluginChangeWrapperCommand;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextElementWrapperCommand
extends PluginChangeWrapperCommand {
    public AbstractContextElementWrapperCommand(EditingDomain domain_p, EObject modelElement_p, EStructuralFeature feature_p, Object value_p) {
        super(domain_p, modelElement_p, feature_p, value_p);
    }

    protected String getContextId() {
        String contextId = null;
        NamedModelElementWithId modelElement = this.getModelElement();
        if (modelElement instanceof Context) {
            contextId = modelElement.getId();
        } else if (modelElement instanceof ContextElement) {
            contextId = ((NamedModelElementWithId)modelElement.eContainer()).getId();
        }
        return contextId;
    }

    protected List<IPluginChangesCommand> handleContextElement(ContextElement contextElement_p) {
        ArrayList<IPluginChangesCommand> commands = new ArrayList<IPluginChangesCommand>(1);
        String contextId = this.getContextId();
        String contextElementId = contextElement_p.getId();
        String contextElementValue = contextElement_p.getReadableValue();
        this.removeContextElement(commands, contextId, contextElementId, contextElement_p);
        ContractElementReference contractElementReference = contextElement_p.getContractElementReference();
        if (contractElementReference != null) {
            this.handleContextElementBasedOnContractElementReference(commands, contextElement_p, contractElementReference, contextId, contextElementId, contextElementValue);
        } else {
            this.handleContextElementBasedOnKey(commands, contextElement_p, contextId, contextElementId, contextElementValue);
        }
        return commands;
    }

    protected void handleContextElementBasedOnKey(List<IPluginChangesCommand> commands_p, ContextElement contextElement_p, String contextId_p, String contextElementId_p, String contextElementValue_p) {
        commands_p.add(this.getMDSoFaPde().getContextExtensionHelper().setContextElementBasedOnKey(contextId_p, contextElementId_p, contextElement_p.getKey(), contextElement_p.getContextType().getTypeHolderClassName(), contextElementValue_p));
    }

    protected void handleContextElementBasedOnContractElementReference(List<IPluginChangesCommand> commands_p, ContextElement contextElement_p, ContractElementReference contractElementReference_p, String contextId_p, String contextElementId_p, String contextElementValue_p) {
        String newContractElementReferenceId = contractElementReference_p.getId();
        commands_p.add(this.getMDSoFaPde().getContractElementRefExtensionHelper().setContractElementReferenceExtension(newContractElementReferenceId, contractElementReference_p.getReferencedContractElementId(), contractElementReference_p.getReferencedFactoryComponentId()));
        commands_p.add(this.getMDSoFaPde().getContextExtensionHelper().setContextElementBasedOnContractElementRef(contextId_p, contextElementId_p, newContractElementReferenceId, contextElementValue_p));
        contextElement_p.setContractReferenceId(newContractElementReferenceId);
    }

    protected void removeContextElement(List<IPluginChangesCommand> commands_p, String contextId, String contextElementId, ContextElement contextElement_p) {
        commands_p.add(this.getMDSoFaPde().getContextExtensionHelper().unsetContextElement(contextId, contextElementId));
        this.removePreviousContractElementReference(commands_p, contextElement_p);
    }

    protected void removePreviousContractElementReference(List<IPluginChangesCommand> commands_p, ContextElement contextElement_p) {
        String previousContractElementReferenceId = contextElement_p.getContractReferenceId();
        if (previousContractElementReferenceId != null) {
            commands_p.add(this.getMDSoFaPde().getContractElementRefExtensionHelper().unsetContractElementReferenceExtension(previousContractElementReferenceId));
        }
        contextElement_p.setContractReferenceId(null);
    }

    @Override
    public boolean doCanUndo() {
        return true;
    }
}

