/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.edit.command;

import java.util.Collection;
import org.eclipse.egf.common.misc.PlatformLocationType;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.edit.command.plugin.PluginChangeWrapperCommand;
import org.eclipse.egf.model.edit.helper.FactoryComponentHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;

public abstract class AbstractModelElementCommand
extends CompoundCommand {
    private PluginChangeWrapperCommand _pluginChangeWrapperCommand;
    private String _workspacePluginId;
    private String _detailedLabel;

    protected AbstractModelElementCommand(EditingDomain editingDomain_p, EObject modelElement_p, EStructuralFeature feature_p, Object value_p) {
        super(0);
        Command crudCommand = this.getCrudCommand(editingDomain_p, modelElement_p, feature_p, value_p);
        if (crudCommand != null) {
            this.append(crudCommand);
        }
        this._workspacePluginId = this.getPluginId((NamedModelElementWithId)modelElement_p);
    }

    protected abstract Command getCrudCommand(EditingDomain var1, EObject var2, EStructuralFeature var3, Object var4);

    public void setPluginChangeCommand(PluginChangeWrapperCommand command_p) {
        this._pluginChangeWrapperCommand = command_p;
    }

    public void execute() {
        super.execute();
        this.doExecute();
    }

    protected void doExecute() {
        if (this.isPluginLocatedInWorkspace() && this._pluginChangeWrapperCommand != null) {
            this._pluginChangeWrapperCommand.setPluginId(this._workspacePluginId);
            this.appendAndExecute((Command)this._pluginChangeWrapperCommand);
        }
    }

    private boolean isPluginLocatedInWorkspace() {
        return this._workspacePluginId != null;
    }

    private String getPluginId(NamedModelElementWithId modelElement_p) {
        FactoryComponent fc = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)modelElement_p);
        return FactoryComponentHelper.getPluginId(fc.getId(), PlatformLocationType.WORKSPACE_ONLY);
    }

    public String getLabel() {
        if (this._detailedLabel == null) {
            this._detailedLabel = this.getDetailedLabel();
        }
        return this._detailedLabel;
    }

    protected String getDetailedLabel() {
        StringBuilder detailedLabel = new StringBuilder(super.getLabel());
        Collection affectedObjects = this.getAffectedObjects();
        Object element = affectedObjects.iterator().next();
        if (element instanceof NamedModelElementWithId) {
            NamedModelElementWithId namedElement = (NamedModelElementWithId)element;
            String name = null;
            name = namedElement instanceof ContextElement ? DataHelper.getLabel((ContextElement)((ContextElement)namedElement)) : namedElement.getName();
            name = name == null ? "" : name;
            detailedLabel.append(' ').append(namedElement.eClass().getName()).append(' ').append(name);
        }
        return detailedLabel.toString();
    }
}

