/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.toolkit.adapters;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class StringButtonFieldEditorAdapter
extends StringButtonFieldEditor
implements IFieldEditor {
    protected int _labelStyle = 16384;
    protected int _valueStyle = 0;
    private Composite _parent;
    private IValidator _validator;

    public StringButtonFieldEditorAdapter(String name_p, String labelText_p, Composite parent_p) {
        this(name_p, labelText_p, parent_p, 16384, 0);
    }

    public StringButtonFieldEditorAdapter(String name_p, String labelText_p, Composite parent_p, int labelStyle_p, int valueStyle_p) {
        this.init(name_p, labelText_p, labelStyle_p, valueStyle_p);
        this.createControl(parent_p);
    }

    protected boolean doCheckState() {
        boolean isValid = super.doCheckState();
        if (this._validator != null) {
            String errorMessage = this._validator.isValid(this.getStringValue());
            boolean bl = isValid = errorMessage == null;
            if (!isValid) {
                this.setErrorMessage(errorMessage);
            }
        }
        return isValid;
    }

    protected boolean checkState() {
        Text textField;
        boolean result = false;
        boolean wasValid = this.isValid();
        boolean emptyStringAllowed = this.isEmptyStringAllowed();
        if (emptyStringAllowed) {
            result = true;
        }
        if ((textField = this.getTextControl()) == null) {
            return false;
        }
        String txt = textField.getText();
        result = txt.trim().length() > 0 || emptyStringAllowed;
        if (!wasValid && (result &= this.doCheckState())) {
            this.clearErrorMessage();
        } else if (!result) {
            String errorMessage = this.getErrorMessage();
            this.showErrorMessage(errorMessage);
        }
        return result;
    }

    protected void init(String name_p, String text_p, int labelStyle_p, int valueStyle_p) {
        Assert.isNotNull((Object)name_p);
        Assert.isNotNull((Object)text_p);
        this._labelStyle = this.checkLabelStyle(labelStyle_p);
        this._valueStyle = this.checkValueStyle(valueStyle_p);
        this.setLabelText(text_p);
        this.setPreferenceName(name_p);
    }

    private int checkLabelStyle(int labelStyle_p) {
        int newStyle = labelStyle_p;
        if ((2 & newStyle) != 0) {
            newStyle -= 2;
        }
        if ((0x40 & newStyle) != 0) {
            newStyle -= 64;
        }
        if (newStyle == 0) {
            newStyle = 16384;
        }
        return newStyle;
    }

    protected int checkValueStyle(int valueStyle_p) {
        return valueStyle_p;
    }

    protected void createControl(Composite parent_p) {
        this._parent = parent_p;
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.horizontalSpacing = 8;
        parent_p.setLayout((Layout)layout);
        this.doFillIntoGrid(parent_p, layout.numColumns);
    }

    protected void doFillIntoGrid(Composite parent_p, int numColumns_p) {
        super.doFillIntoGrid(parent_p, numColumns_p);
    }

    protected abstract String changePressed();

    public Label getLabel() {
        return this.getLabelControl();
    }

    public Control getValueControl() {
        return this.getTextControl();
    }

    public Control getHelperControl() {
        return this.getChangeControl(this._parent);
    }

    public void defaultLayout() {
        Composite parent = this.getLabelControl().getParent();
        GridLayout layout = (GridLayout)parent.getLayout();
        this.fillIntoGrid(parent, layout.numColumns);
    }

    public String getFieldName() {
        return this.getPreferenceName();
    }

    public DialogPage getFieldPage() {
        return this.getPage();
    }

    public IValidator getValidator() {
        return this._validator;
    }

    public boolean isFocused() {
        Control valueControl = this.getValueControl();
        Control helperControl = this.getHelperControl();
        boolean focused = false;
        if (valueControl != null) {
            focused = valueControl.isFocusControl();
        }
        if (helperControl != null) {
            focused |= helperControl.isFocusControl();
        }
        return focused;
    }

    public boolean isHelperEnabled() {
        boolean enabled = false;
        Control helperControl = this.getHelperControl();
        if (helperControl != null) {
            enabled = helperControl.isEnabled();
        }
        return enabled;
    }

    public boolean isValueEnabled() {
        boolean enabled = false;
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            enabled = valueControl.isEnabled();
        }
        return enabled;
    }

    public void layout(int numColumns_p) {
        this.adjustForNumColumns(numColumns_p);
    }

    public void setFieldPage(DialogPage page_p) {
        this.setPage(page_p);
    }

    public void setHelperEnabled(boolean enabled_p) {
        Control helperControl = this.getHelperControl();
        if (helperControl != null) {
            helperControl.setEnabled(enabled_p);
        }
    }

    public void setValidator(IValidator validator_p) {
        this._validator = validator_p;
    }

    public void setValueEnabled(boolean enabled_p) {
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            valueControl.setEnabled(enabled_p);
        }
    }

    public void setFocus() {
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            valueControl.setFocus();
        }
    }
}

