/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext_ng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.fx.core.Range;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.Tuple;
import org.eclipse.fx.ui.controls.styledtext_ng.StyleProxy;
import org.eclipse.fx.ui.controls.styledtext_ng.StyleProxyFactory;
import org.eclipse.fx.ui.controls.styledtext_ng.StyledLineRenderer;

public class DefaultStyleProxyFactory
implements StyleProxyFactory {
    private final ObservableList<Node> nodeList;
    private Map<String[], StyleProxyNode> nodeProxyCache = new HashMap<String[], StyleProxyNode>();
    Map<String[], StyleProxyNode> scheduledForRemoval = new HashMap<String[], StyleProxyNode>();

    public DefaultStyleProxyFactory(ObservableList<Node> nodeList) {
        this.nodeList = nodeList;
    }

    @Override
    public StyleProxy get(String[] stylenames) {
        return this.nodeProxyCache.computeIfAbsent(stylenames, st -> {
            this.scheduledForRemoval.remove(st);
            WrappedStyleProxyNode proxy = new WrappedStyleProxyNode((String[])st);
            this.nodeList.add((Object)proxy);
            return proxy;
        });
    }

    static class StyleProxyNode
    extends Group
    implements StyleProxy {
        final Map<StyledLineRenderer, List<Range>> ranges = new HashMap<StyledLineRenderer, List<Range>>();
        final Map<StyledLineRenderer, Map<Range, Subscription>> boldSubscriptions = new HashMap<StyledLineRenderer, Map<Range, Subscription>>();
        final Map<StyledLineRenderer, Map<Range, Subscription>> italicSubscriptions = new HashMap<StyledLineRenderer, Map<Range, Subscription>>();
        final Map<StyledLineRenderer, Map<Range, Subscription>> fillSubscriptions = new HashMap<StyledLineRenderer, Map<Range, Subscription>>();
        final String[] stylenames;
        private static StyleablePropertyFactory<StyleProxyNode> FACTORY = new StyleablePropertyFactory(Group.getClassCssMetaData());
        private static final CssMetaData<StyleProxyNode, Boolean> BOLD = FACTORY.createBooleanCssMetaData("-efx-styled-bold", s -> s.bold, false, false);
        private static final CssMetaData<StyleProxyNode, Boolean> ITALIC = FACTORY.createBooleanCssMetaData("-efx-styled-italic", s -> s.italic, false, false);
        private static final CssMetaData<StyleProxyNode, Paint> FILL = FACTORY.createPaintCssMetaData("-efx-fill", s -> s.fill, (Paint)Color.BLACK, false);
        private final SimpleStyleableBooleanProperty bold = new SimpleStyleableBooleanProperty(BOLD, this, "bold"){

            protected void invalidated() {
                super.invalidated();
                for (Map.Entry<StyledLineRenderer, List<Range>> e : ranges.entrySet()) {
                    e.getKey().combinedAction(() -> {
                        Map map = boldSubscriptions.getOrDefault(e.getKey(), new HashMap());
                        map.values().forEach(Subscription::dispose);
                        map.clear();
                        if (this.get()) {
                            boldSubscriptions.put((StyledLineRenderer)e.getKey(), ((List)e.getValue()).stream().map(r -> new Tuple(r, (Object)((StyledLineRenderer)e.getKey()).setBold((Range)r))).collect(Collectors.toMap(t -> (Range)t.value1, t -> (Subscription)t.value2)));
                        }
                    });
                }
            }
        };
        private final SimpleStyleableBooleanProperty italic = new SimpleStyleableBooleanProperty(ITALIC, this, "italic"){

            protected void invalidated() {
                super.invalidated();
                for (Map.Entry<StyledLineRenderer, List<Range>> e : ranges.entrySet()) {
                    e.getKey().combinedAction(() -> {
                        Map map = italicSubscriptions.getOrDefault(e.getKey(), new HashMap());
                        map.values().forEach(Subscription::dispose);
                        map.clear();
                        if (this.get()) {
                            italicSubscriptions.put((StyledLineRenderer)e.getKey(), ((List)e.getValue()).stream().map(r -> new Tuple(r, (Object)((StyledLineRenderer)e.getKey()).setItalic((Range)r))).collect(Collectors.toMap(t -> (Range)t.value1, t -> (Subscription)t.value2)));
                        }
                    });
                }
            }
        };
        private final StyleableProperty<Paint> fill = new SimpleStyleableObjectProperty<Paint>(FILL, (Object)this, "fill", (Paint)Color.BLACK){

            protected void invalidated() {
                super.invalidated();
                for (Map.Entry<StyledLineRenderer, List<Range>> e : ranges.entrySet()) {
                    e.getKey().combinedAction(() -> {
                        Map map = fillSubscriptions.getOrDefault(e.getKey(), new HashMap());
                        map.values().forEach(Subscription::dispose);
                        map.clear();
                        Paint paint = (Paint)this.get();
                        fillSubscriptions.put((StyledLineRenderer)e.getKey(), ((List)e.getValue()).stream().map(r -> new Tuple(r, (Object)((StyledLineRenderer)e.getKey()).setForeground(paint, (Range)r))).collect(Collectors.toMap(t -> (Range)t.value1, t -> (Subscription)t.value2)));
                    });
                }
            }
        };

        public StyleProxyNode(String[] stylenames) {
            this.stylenames = stylenames;
            this.getStyleClass().setAll((Object[])stylenames);
            this.setManaged(false);
            this.setVisible(false);
        }

        @Override
        public Subscription addRange(StyledLineRenderer renderer, Range range) {
            this.ranges.computeIfAbsent(renderer, r -> new ArrayList()).add(range);
            if (this.bold.get()) {
                this.boldSubscriptions.computeIfAbsent(renderer, r -> new HashMap()).put(range, renderer.setBold(range));
            }
            if (this.italic.get()) {
                this.italicSubscriptions.computeIfAbsent(renderer, r -> new HashMap()).put(range, renderer.setItalic(range));
            }
            this.fillSubscriptions.computeIfAbsent(renderer, r -> new HashMap()).put(range, renderer.setForeground((Paint)this.fill.getValue(), range));
            return () -> {
                Subscription v;
                List list = this.ranges.getOrDefault(renderer, new ArrayList());
                list.remove(range);
                if (list.isEmpty()) {
                    this.ranges.remove(renderer);
                }
                if ((v = (Subscription)((Map)this.boldSubscriptions.getOrDefault(renderer, new HashMap())).remove(range)) != null) {
                    v.dispose();
                }
                if ((v = (Subscription)((Map)this.italicSubscriptions.getOrDefault(renderer, new HashMap())).remove(range)) != null) {
                    v.dispose();
                }
                if ((v = (Subscription)((Map)this.fillSubscriptions.getOrDefault(renderer, new HashMap())).remove(range)) != null) {
                    v.dispose();
                }
            };
        }

        public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
            return FACTORY.getCssMetaData();
        }

        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return FACTORY.getCssMetaData();
        }
    }

    class WrappedStyleProxyNode
    extends StyleProxyNode {
        public WrappedStyleProxyNode(String[] stylenames) {
            super(stylenames);
        }

        @Override
        public Subscription addRange(StyledLineRenderer renderer, Range range) {
            Subscription sub = super.addRange(renderer, range);
            return () -> {
                sub.dispose();
                if (this.ranges.isEmpty()) {
                    DefaultStyleProxyFactory.this.scheduledForRemoval.put(this.stylenames, this);
                }
            };
        }
    }
}

