/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.impl.generators;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ide.rrobot.model.bundle.BundlePackage;
import org.eclipse.fx.ide.rrobot.model.bundle.BundleProject;
import org.eclipse.fx.ide.rrobot.model.bundle.ComponentDefinitionFile;
import org.eclipse.fx.ide.rrobot.model.bundle.ExportedPackage;
import org.eclipse.fx.ide.rrobot.model.bundle.ImportedPackage;
import org.eclipse.fx.ide.rrobot.model.bundle.ManifestFile;
import org.eclipse.fx.ide.rrobot.model.bundle.PluginXMLFile;
import org.eclipse.fx.ide.rrobot.model.bundle.RequiredBundle;
import org.eclipse.fx.ide.rrobot.model.task.BooleanExpression;
import org.eclipse.fx.ide.rrobot.model.task.ExcludeableElementMixin;
import org.eclipse.fx.ide.rrobot.model.task.Folder;
import org.eclipse.fx.ide.rrobot.model.task.Generator;
import org.eclipse.fx.ide.rrobot.model.task.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BundleManifestGenerator
implements Generator<ManifestFile> {
    public InputStream generate(ManifestFile file, Map<String, Object> data) {
        CharSequence _generateContent = this.generateContent(file, data);
        String _string = _generateContent.toString();
        byte[] _bytes = _string.getBytes();
        return new ByteArrayInputStream(_bytes);
    }

    public CharSequence generateContent(ManifestFile file, final Map<String, Object> data) {
        ArrayList<String> _serviceComponents;
        boolean _isEmpty_3;
        boolean _not_3;
        EList _exportedPackages;
        boolean _isEmpty_2;
        boolean _not_2;
        EList _importedPackages;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Manifest-Version: 1.0");
        _builder.newLine();
        _builder.append((Object)"Bundle-ManifestVersion: 2");
        _builder.newLine();
        _builder.append((Object)"Bundle-Name: ");
        String _bundlename = file.getBundlename();
        _builder.append((Object)_bundlename, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Bundle-SymbolicName: ");
        String _symbolicname = file.getSymbolicname();
        _builder.append((Object)_symbolicname, "");
        EObject _eContainer = file.eContainer();
        PluginXMLFile _pluginxml = ((BundleProject)_eContainer).getPluginxml();
        boolean bl = _notEquals = !Objects.equal((Object)_pluginxml, null);
        if (_notEquals) {
            _builder.append((Object)"; singleton:=true");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Bundle-Version: ");
        String _version = file.getVersion();
        _builder.append((Object)_version, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Bundle-RequiredExecutionEnvironment: ");
        String _executionEnvironment = file.getExecutionEnvironment();
        _builder.append((Object)_executionEnvironment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Bundle-ActivationPolicy: lazy");
        _builder.newLine();
        EList _requiredBundles = file.getRequiredBundles();
        boolean _isEmpty = _requiredBundles.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"Require-Bundle: ");
            EList _requiredBundles_1 = file.getRequiredBundles();
            Functions.Function1<RequiredBundle, Boolean> _function = new Functions.Function1<RequiredBundle, Boolean>(){

                public Boolean apply(RequiredBundle e) {
                    return BundleManifestGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_requiredBundles_1, (Functions.Function1)_function);
            Functions.Function1<RequiredBundle, String> _function_1 = new Functions.Function1<RequiredBundle, String>(){

                public String apply(RequiredBundle it) {
                    return BundleManifestGenerator.this.requireBundleBuilder(it);
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\r\n ");
            _builder.append((Object)_join, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _not_1 = !(_isEmpty_1 = (_importedPackages = file.getImportedPackages()).isEmpty());
        if (_not_1) {
            _builder.append((Object)"Import-Package: ");
            EList _importedPackages_1 = file.getImportedPackages();
            Functions.Function1<ImportedPackage, Boolean> _function_2 = new Functions.Function1<ImportedPackage, Boolean>(){

                public Boolean apply(ImportedPackage e) {
                    return BundleManifestGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_importedPackages_1, (Functions.Function1)_function_2);
            Functions.Function1<ImportedPackage, String> _function_3 = new Functions.Function1<ImportedPackage, String>(){

                public String apply(ImportedPackage it) {
                    return BundleManifestGenerator.this.importPackageBuilder(it);
                }
            };
            Iterable _map_1 = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function_3);
            String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)",\r\n ");
            _builder.append((Object)_join_1, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _not_2 = !(_isEmpty_2 = (_exportedPackages = file.getExportedPackages()).isEmpty());
        if (_not_2) {
            _builder.append((Object)"Export-Package: ");
            EList _exportedPackages_1 = file.getExportedPackages();
            Functions.Function1<ExportedPackage, Boolean> _function_4 = new Functions.Function1<ExportedPackage, Boolean>(){

                public Boolean apply(ExportedPackage e) {
                    return BundleManifestGenerator.this.excludeExpression((ExcludeableElementMixin)e, data);
                }
            };
            Iterable _filter_2 = IterableExtensions.filter((Iterable)_exportedPackages_1, (Functions.Function1)_function_4);
            Functions.Function1<ExportedPackage, String> _function_5 = new Functions.Function1<ExportedPackage, String>(){

                public String apply(ExportedPackage it) {
                    return BundleManifestGenerator.this.exportPackageBuilder(it);
                }
            };
            Iterable _map_2 = IterableExtensions.map((Iterable)_filter_2, (Functions.Function1)_function_5);
            String _join_2 = IterableExtensions.join((Iterable)_map_2, (CharSequence)",\r\n ");
            _builder.append((Object)_join_2, "");
            _builder.newLineIfNotEmpty();
        }
        boolean bl5 = _not_3 = !(_isEmpty_3 = (_serviceComponents = this.serviceComponents(file)).isEmpty());
        if (_not_3) {
            _builder.append((Object)"Service-Component: ");
            ArrayList<String> _serviceComponents_1 = this.serviceComponents(file);
            String _join_3 = IterableExtensions.join(_serviceComponents_1, (CharSequence)",\r\n ");
            _builder.append((Object)_join_3, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public boolean excludeExpression(ExcludeableElementMixin mixin, Map<String, Object> data) {
        boolean _notEquals;
        BooleanExpression _excludeExpression = mixin.getExcludeExpression();
        boolean bl = _notEquals = !Objects.equal((Object)_excludeExpression, null);
        if (_notEquals) {
            BooleanExpression _excludeExpression_1 = mixin.getExcludeExpression();
            boolean _execute = _excludeExpression_1.execute(data);
            return !_execute;
        }
        return true;
    }

    public ArrayList<String> serviceComponents(ManifestFile file) {
        final ArrayList<String> rv = new ArrayList<String>();
        EObject _eContainer = file.eContainer();
        BundleProject project = (BundleProject)_eContainer;
        EList _resources = project.getResources();
        Consumer<Resource> _function = new Consumer<Resource>(){

            @Override
            public void accept(Resource r) {
                BundleManifestGenerator.this.collect(rv, "", r);
            }
        };
        _resources.forEach((Consumer)_function);
        return rv;
    }

    public Boolean collect(List<String> files, String prefix, Resource r) {
        boolean _xifexpression = false;
        if (r instanceof ComponentDefinitionFile) {
            String _name = ((ComponentDefinitionFile)r).getName();
            String _plus = String.valueOf(prefix) + _name;
            _xifexpression = files.add(_plus);
        } else if (r instanceof Folder) {
            Folder f = (Folder)r;
            EList _children = f.getChildren();
            for (Resource c : _children) {
                String _name_1 = ((Folder)r).getName();
                String _plus_1 = String.valueOf(prefix) + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + "/";
                this.collect(files, _plus_2, c);
            }
        }
        return _xifexpression;
    }

    public String exportPackageBuilder(ExportedPackage e) {
        String rv = e.getName();
        boolean _eIsSet = e.eIsSet((EStructuralFeature)BundlePackage.Literals.EXPORTED_PACKAGE__VERSION);
        if (_eIsSet) {
            String _concat;
            Object _eGet = e.eGet((EStructuralFeature)BundlePackage.Literals.EXPORTED_PACKAGE__VERSION);
            String _plus = ";version=\"" + _eGet;
            String _plus_1 = String.valueOf(_plus) + "\"";
            rv = _concat = rv.concat(_plus_1);
        }
        return rv;
    }

    public String importPackageBuilder(ImportedPackage i) {
        boolean _eIsSet_1;
        String rv = i.getName();
        boolean _or = false;
        boolean _eIsSet = i.eIsSet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MIN_VERSION);
        _or = _eIsSet ? true : (_eIsSet_1 = i.eIsSet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MAX_VERSION));
        if (_or) {
            String _concat_7;
            boolean _not;
            String _concat;
            rv = _concat = rv.concat(";version=\"");
            boolean _eIsSet_2 = i.eIsSet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MAX_VERSION);
            boolean bl = _not = !_eIsSet_2;
            if (_not) {
                String _concat_1;
                Object _eGet = i.eGet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MIN_VERSION);
                String _string = _eGet.toString();
                rv = _concat_1 = rv.concat(_string);
            } else {
                String _concat_6;
                String _concat_5;
                String _concat_4;
                String _concat_3;
                String _concat_2;
                boolean _isMinExclusive = i.isMinExclusive();
                rv = _isMinExclusive ? (_concat_2 = rv.concat("(")) : (_concat_3 = rv.concat("["));
                Object _eGet_1 = i.eGet((EStructuralFeature)BundlePackage.Literals.IMPORTED_PACKAGE__MIN_VERSION);
                String _string_1 = _eGet_1.toString();
                rv = _concat_4 = rv.concat(_string_1);
                boolean _isMaxExclusive = i.isMaxExclusive();
                rv = _isMaxExclusive ? (_concat_5 = rv.concat(")")) : (_concat_6 = rv.concat("]"));
            }
            rv = _concat_7 = rv.concat("\"");
        }
        return rv;
    }

    public String requireBundleBuilder(RequiredBundle r) {
        boolean _eIsSet_1;
        String rv = r.getName();
        boolean _or = false;
        boolean _eIsSet = r.eIsSet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MIN_VERSION);
        _or = _eIsSet ? true : (_eIsSet_1 = r.eIsSet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MAX_VERSION));
        if (_or) {
            String _concat_7;
            boolean _not;
            String _concat;
            rv = _concat = rv.concat("bundle-version=\"");
            boolean _eIsSet_2 = r.eIsSet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MAX_VERSION);
            boolean bl = _not = !_eIsSet_2;
            if (_not) {
                String _concat_1;
                Object _eGet = r.eGet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MIN_VERSION);
                String _string = _eGet.toString();
                rv = _concat_1 = rv.concat(_string);
            } else {
                String _concat_6;
                String _concat_5;
                String _concat_4;
                String _concat_3;
                String _concat_2;
                boolean _isMinExclusive = r.isMinExclusive();
                rv = _isMinExclusive ? (_concat_2 = rv.concat("(")) : (_concat_3 = rv.concat("["));
                Object _eGet_1 = r.eGet((EStructuralFeature)BundlePackage.Literals.REQUIRED_BUNDLE__MIN_VERSION);
                String _string_1 = _eGet_1.toString();
                rv = _concat_4 = rv.concat(_string_1);
                boolean _isMaxExclusive = r.isMaxExclusive();
                rv = _isMaxExclusive ? (_concat_5 = rv.concat(")")) : (_concat_6 = rv.concat("]"));
            }
            rv = _concat_7 = rv.concat("\"");
        }
        return rv;
    }
}

