/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.dialog;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import org.eclipse.fx.ui.controls.stage.DefaultFramePane;
import org.eclipse.fx.ui.panes.GridData;
import org.eclipse.fx.ui.panes.GridLayoutPane;

public class Dialog
extends DefaultFramePane {
    private final DialogContentPane dialogPane;

    public Dialog(Node clientArea, String frameTitle) {
        this(new DefaultDialogContentPane(), clientArea, frameTitle);
    }

    public <D extends Pane> Dialog(D pane, Node clientArea, String frameTitle) {
        super(pane, true);
        this.dialogPane = pane;
        this.dialogPane.setActionConsumer(this::handleButtonPress);
        this.setClientArea(clientArea);
        this.setTitle(frameTitle);
        this.getStyleClass().add((Object)"efx-dialog");
    }

    @Override
    protected final void requestCancelClose() {
        this.handleCancel();
    }

    protected void handleButtonPress(DialogButton button) {
        if (button.type == ButtonType.OK) {
            this.handleOk();
        } else if (button.type == ButtonType.CANCEL) {
            this.handleCancel();
        }
    }

    protected void handleOk() {
        this.close();
    }

    protected void handleCancel() {
        this.close();
    }

    protected DialogContentPane getDialogPane() {
        return this.dialogPane;
    }

    public ObservableList<DialogButton> getButtonList() {
        return this.dialogPane.getButtonList();
    }

    @Override
    protected void updateClientArea(ObservableValue<? extends Node> o, Node oldClientArea, Node newClientArea) {
        this.dialogPane.getDialogContentNodeProperty().set((Object)newClientArea);
    }

    public DialogButton createOKButton() {
        return new DialogButton(ButtonType.OK, "OK");
    }

    public DialogButton createCancelButton() {
        return new DialogButton(ButtonType.CANCEL, "Cancel");
    }

    protected void addDefaultButtons() {
        this.getButtonList().addAll((Object[])new DialogButton[]{this.createOKButton(), this.createCancelButton()});
    }

    public static Dialog createSimpleDialog(Node clientArea, String frameTitle) {
        Dialog d = new Dialog(clientArea, frameTitle);
        d.addDefaultButtons();
        return d;
    }

    public static enum ButtonType {
        OK,
        CANCEL,
        CUSTOM;

    }

    public static class DefaultDialogContentPane
    extends BorderPane
    implements DialogContentPane {
        private final GridLayoutPane buttonArea = new GridLayoutPane();
        private final ObservableList<DialogButton> buttonList = FXCollections.observableArrayList();
        private Consumer<DialogButton> actionConsumer;
        private BorderPane clientAreaContainer = new BorderPane();

        public DefaultDialogContentPane() {
            this.getStyleClass().add((Object)"efx-dialog-pane");
            this.buttonArea.setMakeColumnsEqualWidth(true);
            this.buttonList.addListener(c -> {
                this.buttonArea.setNumColumns(this.buttonList.size());
                while (c.next()) {
                    if (c.wasAdded()) {
                        this.buttonArea.getChildren().addAll(c.getFrom(), (Collection)c.getAddedSubList().stream().map(b -> {
                            Button bu = new Button(b.label);
                            bu.setOnAction(arg_0 -> this.lambda$3((DialogButton)b, arg_0));
                            GridLayoutPane.setConstraint((Node)bu, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.FILL, false, false));
                            return bu;
                        }).collect(Collectors.toList()));
                    }
                    if (!c.wasRemoved()) continue;
                    this.buttonArea.getChildren().removeIf(b -> c.getRemoved().contains(b.getUserData()));
                }
            });
            BorderPane.setAlignment((Node)this.buttonArea, (Pos)Pos.BOTTOM_RIGHT);
            HBox box = new HBox(new Node[]{this.buttonArea});
            box.getStyleClass().add((Object)"efx-dialog-button-area");
            box.setAlignment(Pos.CENTER_RIGHT);
            this.setBottom((Node)box);
            BorderPane.setAlignment((Node)this.buttonArea, (Pos)Pos.BOTTOM_RIGHT);
            this.clientAreaContainer = new BorderPane();
            this.clientAreaContainer.getStyleClass().add((Object)"efx-dialog-client-area");
            this.setCenter((Node)this.clientAreaContainer);
        }

        @Override
        public void setActionConsumer(Consumer<DialogButton> actionConsumer) {
            this.actionConsumer = actionConsumer;
        }

        @Override
        public ObservableList<DialogButton> getButtonList() {
            return this.buttonList;
        }

        @Override
        public ObjectProperty<Node> getDialogContentNodeProperty() {
            return this.clientAreaContainer.centerProperty();
        }

        public String getUserAgentStylesheet() {
            return Dialog.class.getResource("dialog.css").toExternalForm();
        }

        private /* synthetic */ void lambda$3(DialogButton dialogButton, ActionEvent e) {
            this.actionConsumer.accept(dialogButton);
        }
    }

    public static class DialogButton {
        public String label;
        private ButtonType type;

        DialogButton(ButtonType type, String label) {
            this.type = type;
            this.label = label;
        }

        public DialogButton(String label) {
            this(ButtonType.CUSTOM, label);
        }
    }

    public static interface DialogContentPane {
        public ObjectProperty<Node> getDialogContentNodeProperty();

        public ObservableList<DialogButton> getButtonList();

        public void setActionConsumer(Consumer<DialogButton> var1);
    }
}

