/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuBar;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;

public abstract class BaseMenuBarRenderer<N>
extends BaseRenderer<MMenu, WMenuBar<N>>
implements EventProcessor.ChildrenHandler<MMenu, MMenuElement> {
    @PostConstruct
    void init(IEventBroker eventBroker) {
        EventProcessor.attachChildProcessor(eventBroker, this);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Override
    public void doProcessContent(MMenu element) {
        WMenuBar menuBar = (WMenuBar)this.getWidget((MUIElement)element);
        for (MMenuElement e : element.getChildren()) {
            Object widget;
            if (!e.isToBeRendered() || !((widget = this.engineCreateWidget(e)) instanceof WMenu) || !e.isVisible()) continue;
            menuBar.addElement((WMenu)widget);
        }
    }

    public void childRendered(MMenu parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WMenuBar menu = (WMenuBar)this.getWidget((MUIElement)parentElement);
        WMenuElement widget = (WMenuElement)element.getWidget();
        if (widget instanceof WMenu) {
            menu.addElement(idx, (WMenu)widget);
        }
    }

    public void hideChild(MMenu container, MUIElement changedObj) {
        WMenuBar menu = (WMenuBar)this.getWidget((MUIElement)container);
        if (menu == null) {
            return;
        }
        WMenuElement widget = (WMenuElement)changedObj.getWidget();
        if (widget != null) {
            menu.removeElement(widget);
        }
    }

    @Override
    public void handleChildrenAddition(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenRemove(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }
}

