/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractHandler
extends AggregateLifeCycle
implements Handler {
    private static final Logger LOG = Log.getLogger(AbstractHandler.class);
    private Server _server;

    protected void doStart() throws Exception {
        LOG.debug("starting {}", new Object[]{this});
        super.doStart();
    }

    protected void doStop() throws Exception {
        LOG.debug("stopping {}", new Object[]{this});
        super.doStop();
    }

    @Override
    public void setServer(Server server) {
        Server old_server = this._server;
        if (old_server != null && old_server != server) {
            old_server.getContainer().removeBean((Object)this);
        }
        this._server = server;
        if (this._server != null && this._server != old_server) {
            this._server.getContainer().addBean((Object)this);
        }
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        super.destroy();
        if (this._server != null) {
            this._server.getContainer().removeBean((Object)this);
        }
    }

    public void dumpThis(Appendable out) throws IOException {
        out.append(this.toString()).append(" - ").append(this.getState()).append('\n');
    }
}

