/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.util.ITextRegion;

public class TextRegions {
    public static <T extends ITextRegion> List<T> difference(Iterable<T> r1, Iterable<? extends ITextRegion> r2) {
        ArrayList regions1 = Lists.newArrayList(r1);
        ArrayList regions2 = Lists.newArrayList(r2);
        Collections.sort(regions1, Comp.INSTANCE);
        Collections.sort(regions2, Comp.INSTANCE);
        ArrayList missing = Lists.newArrayList();
        int i1 = 0;
        int i2 = 0;
        while (i1 < regions1.size() && i2 < regions2.size()) {
            ITextRegion t2;
            ITextRegion t1 = (ITextRegion)regions1.get(i1);
            int compareTo = Comp.INSTANCE.compare(t1, t2 = (ITextRegion)regions2.get(i2));
            if (compareTo == 0) {
                ++i1;
                ++i2;
                continue;
            }
            if (compareTo < 1) {
                missing.add(t1);
                ++i1;
                continue;
            }
            ++i2;
        }
        while (i1 < regions1.size()) {
            missing.add(regions1.get(i1));
            ++i1;
        }
        return ImmutableList.copyOf((Collection)missing);
    }

    public static ITextSegment merge(Iterable<? extends ITextSegment> segments) {
        Iterator<? extends ITextSegment> it = segments.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException();
        }
        ITextSegment first = it.next();
        int minOffset = first.getOffset();
        int maxEndOffset = first.getEndOffset();
        while (it.hasNext()) {
            ITextSegment next = it.next();
            int offset = next.getOffset();
            int endOffset = next.getEndOffset();
            if (offset < minOffset) {
                minOffset = offset;
            }
            if (endOffset <= maxEndOffset) continue;
            maxEndOffset = endOffset;
        }
        return new TextSegment(first.getTextRegionAccess(), minOffset, maxEndOffset - minOffset);
    }

    public static List<ILineRegion> expandToLines(ITextSegment segment, int leadingLinesToAdd, int trailingLinesToAdd) {
        ILineRegion line;
        int i;
        ArrayList lines = Lists.newArrayList(segment.getLineRegions());
        for (i = 1; i < leadingLinesToAdd; ++i) {
            line = ((ILineRegion)lines.get(0)).getPreviousLine();
            if (line == null) continue;
            lines.add(0, line);
        }
        for (i = 1; i < trailingLinesToAdd; ++i) {
            line = ((ILineRegion)lines.get(lines.size() - 1)).getNextLine();
            if (line == null) continue;
            lines.add(line);
        }
        return lines;
    }

    private static enum Comp implements Comparator<ITextRegion>
    {
        INSTANCE;


        @Override
        public int compare(ITextRegion o1, ITextRegion o2) {
            int cmp1 = o1.getOffset() - o2.getOffset();
            if (cmp1 != 0) {
                return cmp1;
            }
            int cmp2 = o1.getLength() - o2.getLength();
            if (cmp2 != 0) {
                return cmp2;
            }
            return 0;
        }
    }
}

