/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.mwe;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectionUtil {
    private static final Map<String, Map<String, Field>> fieldDictionary = new HashMap<String, Map<String, Field>>();

    private ReflectionUtil() {
    }

    public static String getSimpleName(Object element) {
        return element == null ? "null" : (element instanceof String ? (String)element : ReflectionUtil.getSimpleClassName(element));
    }

    public static String getNameToString(Object element) {
        return element == null ? "null" : element.toString();
    }

    public static boolean checkFields(Object element) {
        if (element == null || element instanceof String) {
            return false;
        }
        if (Object[].class.isAssignableFrom(element.getClass())) {
            return ((Object[])element).length > 0;
        }
        Map<String, Field> fields = ReflectionUtil.getFieldMap(element.getClass());
        return !fields.isEmpty();
    }

    public static List<String> getFieldNames(Object element) {
        ArrayList<String> result = new ArrayList<String>();
        if (element instanceof Object[]) {
            int i = 0;
            while (i < ((Object[])element).length) {
                result.add("[" + i + "]");
                ++i;
            }
        } else {
            result.addAll(ReflectionUtil.getFieldMap(element.getClass()).keySet());
        }
        return result;
    }

    public static Object getFieldValue(Object object, String name) {
        try {
            Field field = ReflectionUtil.getField(object, name);
            Class<?> type = field.getType();
            if (type.isPrimitive() || type == String.class) {
                return field.get(object).toString();
            }
            return field.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getSimpleClassName(Object element) {
        String fqn = element.getClass().getName();
        int index = fqn.lastIndexOf(46);
        if (element instanceof Object[]) {
            return String.valueOf(fqn.substring(index + 1, fqn.length() - 1)) + "[" + ((Object[])element).length + "]";
        }
        return fqn.substring(index + 1);
    }

    private static Field getField(Object object, String name) {
        try {
            return ReflectionUtil.getFieldMap(object.getClass()).get(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static synchronized Map<String, Field> getFieldMap(Class<?> cls) {
        String clsName = cls.getName();
        if (!fieldDictionary.containsKey(clsName)) {
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            Class<?> clazz = cls;
            while (!Object.class.equals(clazz)) {
                Field[] fields = cls.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    Field field = fields[i];
                    field.setAccessible(true);
                    if (!fieldMap.containsKey(field.getName())) {
                        fieldMap.put(field.getName(), field);
                    }
                    ++i;
                }
                clazz = clazz.getSuperclass();
            }
            fieldDictionary.put(clsName, fieldMap);
        }
        return fieldDictionary.get(clsName);
    }
}

