/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OSGiFXMLLoader {
    private static @NonNull ClassLoader getClassLoader(Class<?> clazz) {
        return clazz.getClassLoader();
    }

    private static @NonNull ClassLoader getClassLoader(Bundle bundle) {
        return ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
    }

    public static <O> O load(@NonNull Class<?> requester, @NonNull String relativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        URL url = requester.getResource(relativeFxmlPath);
        if (url == null) {
            throw new IOException("Unable to load '" + relativeFxmlPath + "' relative to '" + requester + "'");
        }
        return OSGiFXMLLoader.load(OSGiFXMLLoader.getClassLoader(requester), url, resourceBundle, builderFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull Class<?> requester, @NonNull String relativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        URL url = requester.getResource(relativeFxmlPath);
        if (url == null) {
            throw new IOException("Unable to load '" + relativeFxmlPath + "' relative to '" + requester + "'");
        }
        return OSGiFXMLLoader.loadWithController(OSGiFXMLLoader.getClassLoader(requester), url, resourceBundle, builderFactory);
    }

    public static <O> O load(@NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        URL url = bundle.getResource(bundleRelativeFxmlPath);
        if (url == null) {
            throw new IOException("Unable to load '" + bundleRelativeFxmlPath + "' relative to '" + bundle + "'");
        }
        return OSGiFXMLLoader.load(OSGiFXMLLoader.getClassLoader(bundle), url, resourceBundle, builderFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        URL url = bundle.getResource(bundleRelativeFxmlPath);
        if (url == null) {
            throw new IOException("Unable to load '" + bundleRelativeFxmlPath + "' relative to '" + bundle + "'");
        }
        return OSGiFXMLLoader.loadWithController(OSGiFXMLLoader.getClassLoader(bundle), url, resourceBundle, builderFactory);
    }

    public static <O> O load(@NonNull ClassLoader classloader, @NonNull URL url, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        return OSGiFXMLLoader.load(classloader, url, resourceBundle, builderFactory, null);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull ClassLoader classloader, @NonNull URL url, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        return OSGiFXMLLoader.loadWithController(classloader, url, null, resourceBundle, builderFactory, null);
    }

    public static <O> O load(@NonNull Class<?> requester, @NonNull String relativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        URL url = requester.getResource(relativeFxmlPath);
        if (url == null) {
            throw new IOException("Unable to load '" + relativeFxmlPath + "' relative to '" + requester + "'");
        }
        return OSGiFXMLLoader.load(OSGiFXMLLoader.getClassLoader(requester), url, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull Class<?> requester, @NonNull String relativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        URL url = requester.getResource(relativeFxmlPath);
        if (url == null) {
            throw new IOException("Unable to load '" + relativeFxmlPath + "' relative to '" + requester + "'");
        }
        return OSGiFXMLLoader.loadWithController(OSGiFXMLLoader.getClassLoader(requester), url, null, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O> O load(@NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        URL url = bundle.getResource(bundleRelativeFxmlPath);
        if (url == null) {
            throw new IOException("Unable to load '" + bundleRelativeFxmlPath + "' relative to '" + bundle + "'");
        }
        return OSGiFXMLLoader.load(OSGiFXMLLoader.getClassLoader(bundle), url, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        URL url = bundle.getResource(bundleRelativeFxmlPath);
        if (url == null) {
            throw new IOException("Unable to load '" + bundleRelativeFxmlPath + "' relative to '" + bundle + "'");
        }
        return OSGiFXMLLoader.loadWithController(OSGiFXMLLoader.getClassLoader(bundle), url, null, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O> O load(@NonNull ClassLoader classloader, @NonNull URL url, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        return (O)OSGiFXMLLoader.loadWithController((ClassLoader)classloader, (URL)url, null, (ResourceBundle)resourceBundle, (BuilderFactory)builderFactory, controllerFactory).node;
    }

    public static <O> O load(@NonNull ClassLoader classloader, @Nullable URL url, @NonNull InputStream stream, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        return (O)OSGiFXMLLoader.loadWithController((ClassLoader)classloader, (URL)url, (InputStream)stream, (ResourceBundle)resourceBundle, (BuilderFactory)builderFactory, controllerFactory).node;
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull ClassLoader classloader, @Nullable URL url, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        return OSGiFXMLLoader.loadWithController(classloader, url, null, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull ClassLoader classloader, @Nullable URL url, @Nullable InputStream stream, @Nullable ResourceBundle resourceBundle, final @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(url);
        loader.setClassLoader(classloader);
        loader.setResources(resourceBundle);
        if (builderFactory == null) {
            loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory(classloader));
        } else {
            loader.setBuilderFactory(new BuilderFactory(classloader){
                private JavaFXBuilderFactory orgBuilder;
                {
                    this.orgBuilder = new JavaFXBuilderFactory(classLoader);
                }

                public Builder<?> getBuilder(Class<?> type) {
                    Builder b = builderFactory.getBuilder(type);
                    if (b == null) {
                        b = this.orgBuilder.getBuilder(type);
                    }
                    return b;
                }
            });
        }
        if (controllerFactory != null) {
            loader.setControllerFactory(controllerFactory);
        }
        if (stream != null) {
            Object value = loader.load(stream);
            if (value != null) {
                return new FXMLData<Object, Object>(value, loader.getController(), (Map<String, Object>)loader.getNamespace());
            }
            throw new IOException("Unable to construct UI from FXML '" + url + "'");
        }
        if (url != null) {
            Throwable throwable = null;
            Object var8_10 = null;
            try (InputStream in = url.openStream();){
                Object value = loader.load(in);
                if (value != null) {
                    return new FXMLData<Object, Object>(value, loader.getController(), (Map<String, Object>)loader.getNamespace());
                }
                throw new IOException("Unable to construct UI from FXML '" + url + "'");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new IllegalArgumentException("At least one of the parameters URL or InputStream must be set");
    }

    public static class FXMLData<N, C> {
        public final @NonNull N node;
        public final @Nullable C controller;
        public final @NonNull Map<String, Object> namspace;

        FXMLData(@NonNull N node, @Nullable C controller, @NonNull Map<String, Object> namspace) {
            this.node = node;
            this.controller = controller;
            this.namspace = namspace;
        }
    }
}

