/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.services;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.fx.ui.workbench.renderers.fx.services.LightweightDialogTransitionService;

public class FlyInTransitionService
implements LightweightDialogTransitionService {
    private boolean fadeGrayArea;

    public FlyInTransitionService() {
        this(false);
    }

    public FlyInTransitionService(boolean fadeGrayArea) {
        this.fadeGrayArea = fadeGrayArea;
    }

    @Override
    public void showDialog(MUIElement container, Pane containerNode, Pane dialogOverlayContainer, Node grayArea, Node dialog, Runnable finished) {
        FadeTransition fd = new FadeTransition(Duration.millis((double)300.0), (Node)dialogOverlayContainer);
        fd.setFromValue(0.0);
        fd.setToValue(1.0);
        TranslateTransition t = new TranslateTransition(Duration.millis((double)300.0), dialog);
        t.setFromY(-1.0 * (dialog.getLayoutY() + dialog.prefHeight(-1.0)));
        t.setToY(0.0);
        t.setInterpolator(Interpolator.EASE_OUT);
        if (finished != null) {
            t.setOnFinished(e -> finished.run());
        }
        ParallelTransition p = new ParallelTransition(new Animation[]{t});
        if (this.fadeGrayArea) {
            p.getChildren().add((Object)fd);
        }
        p.play();
    }

    @Override
    public void hideDialog(MUIElement container, Pane containerNode, Pane dialogOverlayContainer, Node grayArea, Node dialog, Runnable finished) {
        FadeTransition fd = new FadeTransition(Duration.millis((double)300.0), (Node)dialogOverlayContainer);
        fd.setFromValue(1.0);
        fd.setToValue(0.0);
        TranslateTransition t = new TranslateTransition(Duration.millis((double)300.0), dialog);
        t.setFromY(0.0);
        t.setToY(-1.0 * (dialog.getLayoutY() + dialog.prefHeight(-1.0)));
        t.setInterpolator(Interpolator.EASE_IN);
        if (finished != null) {
            t.setOnFinished(e -> finished.run());
        }
        ParallelTransition p = new ParallelTransition(new Animation[]{t});
        if (this.fadeGrayArea) {
            p.getChildren().add((Object)fd);
        }
        p.play();
    }
}

