/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base;

import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.fx.ui.workbench.services.ELifecycleService;
import org.eclipse.fx.ui.workbench.services.lifecycle.annotation.InitContext;

public class Util {
    public static void setup(MContext model, IEclipseContext context) {
        Util.populateModelInterfaces(model, context, model.getClass().getInterfaces());
        for (String variable : model.getVariables()) {
            context.declareModifiable(variable);
        }
        Map props = model.getProperties();
        for (String key : props.keySet()) {
            context.set(key, props.get(key));
        }
        model.setContext(context);
        ELifecycleService service = (ELifecycleService)context.get(ELifecycleService.class);
        if (service != null) {
            MApplication app = (MApplication)context.get(MApplication.class);
            IEclipseContext appContext = app != null ? app.getContext() : null;
            IEclipseContext localContext = appContext != null ? appContext.getActiveChild() : null;
            service.validateAnnotation(InitContext.class, (MApplicationElement)model, context, localContext);
        }
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            context.set(intf.getName(), (Object)contextModel);
            Util.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }
}

