/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.dialog;

import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.ui.controls.dialog.Dialog;
import org.eclipse.fx.ui.controls.image.FontIconView;

public class TitleAreaDialog
extends Dialog {
    private Subscription currentTemporyMessage;

    public TitleAreaDialog(String frameTitle, String title, String message) {
        this(null, frameTitle, title, message);
    }

    public TitleAreaDialog(Node clientArea, String frameTitle, String title, String message) {
        super(new TitleAreaDialogPane(), clientArea, frameTitle);
        this.getDialogPane().titleProperty().set((Object)title);
        this.getDialogPane().titleMessageProperty().set((Object)message);
    }

    @Override
    protected TitleAreaDialogPane getDialogPane() {
        return (TitleAreaDialogPane)super.getDialogPane();
    }

    public Subscription showTemporaryMessage(String temporaryMessage, String ... messageStyles) {
        if (this.currentTemporyMessage != null) {
            this.currentTemporyMessage.dispose();
        }
        TitleAreaDialogPane dialogPane = this.getDialogPane();
        dialogPane.titleMessage.setText(temporaryMessage);
        dialogPane.titleMessage.getStyleClass().addAll((Object[])messageStyles);
        this.currentTemporyMessage = () -> {
            titleAreaDialogPane.titleMessage.setText((String)this.titleProperty().get());
            titleAreaDialogPane.titleMessage.getStyleClass().removeAll((Object[])messageStyles);
            this.currentTemporyMessage = null;
        };
        return this.currentTemporyMessage;
    }

    public Subscription showTemporaryWarningMessage(String temporaryMessage) {
        return this.showTemporaryMessage(temporaryMessage, "warning-message");
    }

    public Subscription showTemporaryErrorMessage(String temporaryMessage) {
        return this.showTemporaryMessage(temporaryMessage, "error-message");
    }

    public Subscription showTemporaryInfoMessage(String temporaryMessage) {
        return this.showTemporaryMessage(temporaryMessage, "info-message");
    }

    public static class TitleAreaDialogPane
    extends Dialog.DefaultDialogContentPane {
        private final Label titleLabel;
        final Label titleMessage;

        public TitleAreaDialogPane() {
            HBox box = new HBox();
            box.getStyleClass().add((Object)"efx-dialog-title-area");
            VBox messageArea = new VBox();
            messageArea.getStyleClass().add((Object)"efx-dialog-messageArea-area");
            this.titleLabel = new Label();
            this.titleLabel.getStyleClass().add((Object)"efx-dialog-title");
            this.titleMessage = new Label();
            this.titleMessage.setWrapText(true);
            this.titleMessage.getStyleClass().add((Object)"efx-dialog-title-message");
            messageArea.getChildren().add((Object)this.titleLabel);
            messageArea.getChildren().add((Object)this.titleMessage);
            HBox.setHgrow((Node)messageArea, (Priority)Priority.ALWAYS);
            StackPane container = new StackPane();
            container.getStyleClass().add((Object)"efx-dialog-graphic-container");
            ImageView titleImage = new ImageView();
            titleImage.getStyleClass().add((Object)"efx-dialog-title-image");
            FontIconView v = new FontIconView();
            v.getStyleClass().add((Object)"efx-dialog-title-font-icon");
            container.getChildren().addAll((Object[])new Node[]{titleImage, v});
            box.getChildren().addAll((Object[])new Node[]{messageArea, container});
            this.setTop((Node)box);
        }

        public StringProperty titleProperty() {
            return this.titleLabel.textProperty();
        }

        public StringProperty titleMessageProperty() {
            return this.titleMessage.textProperty();
        }
    }
}

